/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageDataFormats;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.LedgerMetadataIndexStats;
import org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadataIndex
implements Closeable {
    private static final long STORAGE_FLAGS = -61181L;
    private final ConcurrentLongHashMap<DbLedgerStorageDataFormats.LedgerData> ledgers;
    private final AtomicInteger ledgersCount;
    private final KeyValueStorage ledgersDb;
    private final LedgerMetadataIndexStats stats;
    private final ConcurrentLinkedQueue<Map.Entry<Long, DbLedgerStorageDataFormats.LedgerData>> pendingLedgersUpdates;
    private final Set<Long> pendingDeletedLedgers;
    private final ReentrantLock[] locks = new ReentrantLock[16];
    private static final Logger log = LoggerFactory.getLogger(LedgerMetadataIndex.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LedgerMetadataIndex(ServerConfiguration conf, KeyValueStorageFactory storageFactory, String basePath, StatsLogger stats) throws IOException {
        this.ledgersDb = storageFactory.newKeyValueStorage(basePath, "ledgers", KeyValueStorageFactory.DbConfigType.LedgerMetadata, conf);
        this.ledgers = ConcurrentLongHashMap.newBuilder().build();
        this.ledgersCount = new AtomicInteger();
        try (KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>> iterator = this.ledgersDb.iterator();){
            while (iterator.hasNext()) {
                Map.Entry<byte[], byte[]> entry = iterator.next();
                long ledgerId = ArrayUtil.getLong(entry.getKey(), 0);
                if (ledgerId < 0L) continue;
                DbLedgerStorageDataFormats.LedgerData ledgerData = DbLedgerStorageDataFormats.LedgerData.parseFrom((byte[])entry.getValue());
                this.ledgers.put(ledgerId, ledgerData);
                this.ledgersCount.incrementAndGet();
            }
        }
        this.pendingLedgersUpdates = new ConcurrentLinkedQueue();
        this.pendingDeletedLedgers = Sets.newConcurrentHashSet();
        this.stats = new LedgerMetadataIndexStats(stats, () -> this.ledgersCount.get());
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.ledgersDb.close();
    }

    public DbLedgerStorageDataFormats.LedgerData get(long ledgerId) throws IOException {
        DbLedgerStorageDataFormats.LedgerData ledgerData = this.ledgers.get(ledgerId);
        if (ledgerData == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ledger not found {}", (Object)ledgerId);
            }
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return ledgerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long ledgerId, DbLedgerStorageDataFormats.LedgerData ledgerData) throws IOException {
        ledgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setExists(true).build();
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            if (this.ledgers.put(ledgerId, ledgerData) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Added new ledger {}", (Object)ledgerId);
                }
                this.ledgersCount.incrementAndGet();
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, ledgerData));
            this.pendingDeletedLedgers.remove(ledgerId);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long ledgerId) throws IOException {
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            if (this.ledgers.remove(ledgerId) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removed ledger {}", (Object)ledgerId);
                }
                this.ledgersCount.decrementAndGet();
            }
            this.pendingDeletedLedgers.add(ledgerId);
            this.pendingLedgersUpdates.removeIf(e -> (Long)e.getKey() == ledgerId);
        }
        finally {
            lock.unlock();
        }
    }

    public Iterable<Long> getActiveLedgersInRange(final long firstLedgerId, final long lastLedgerId) throws IOException {
        if (firstLedgerId <= 0L && lastLedgerId == Long.MAX_VALUE) {
            return this.ledgers.keys();
        }
        return Iterables.filter(this.ledgers.keys(), (Predicate)new Predicate<Long>(){

            public boolean apply(Long ledgerId) {
                return ledgerId >= firstLedgerId && ledgerId < lastLedgerId;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFenced(long ledgerId) throws IOException {
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            DbLedgerStorageDataFormats.LedgerData ledgerData = this.get(ledgerId);
            if (ledgerData.getFenced()) {
                boolean bl = false;
                return bl;
            }
            DbLedgerStorageDataFormats.LedgerData newLedgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setFenced(true).build();
            if (this.ledgers.put(ledgerId, newLedgerData) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Re-inserted fenced ledger {}", (Object)ledgerId);
                }
                this.ledgersCount.incrementAndGet();
            } else if (log.isDebugEnabled()) {
                log.debug("Set fenced ledger {}", (Object)ledgerId);
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, newLedgerData));
            this.pendingDeletedLedgers.remove(ledgerId);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLimbo(long ledgerId) throws IOException {
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            DbLedgerStorageDataFormats.LedgerData ledgerData = this.get(ledgerId);
            if (ledgerData.getLimbo()) {
                boolean bl = false;
                return bl;
            }
            DbLedgerStorageDataFormats.LedgerData newLedgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setLimbo(true).build();
            if (this.ledgers.put(ledgerId, newLedgerData) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Re-inserted limbo ledger {}", (Object)ledgerId);
                }
                this.ledgersCount.incrementAndGet();
            } else if (log.isDebugEnabled()) {
                log.debug("Set limbo ledger {}", (Object)ledgerId);
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, newLedgerData));
            this.pendingDeletedLedgers.remove(ledgerId);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearLimbo(long ledgerId) throws IOException {
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            DbLedgerStorageDataFormats.LedgerData ledgerData = this.get(ledgerId);
            if (ledgerData == null) {
                throw new Bookie.NoLedgerException(ledgerId);
            }
            boolean oldValue = ledgerData.getLimbo();
            DbLedgerStorageDataFormats.LedgerData newLedgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setLimbo(false).build();
            if (this.ledgers.put(ledgerId, newLedgerData) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Re-inserted limbo ledger {}", (Object)ledgerId);
                }
                this.ledgersCount.incrementAndGet();
            } else if (log.isDebugEnabled()) {
                log.debug("Set limbo ledger {}", (Object)ledgerId);
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, newLedgerData));
            this.pendingDeletedLedgers.remove(ledgerId);
            boolean bl = oldValue;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        ReentrantLock lock = this.lockForLedger(ledgerId);
        lock.lock();
        try {
            DbLedgerStorageDataFormats.LedgerData ledgerData = this.ledgers.get(ledgerId);
            if (ledgerData == null) {
                ledgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder().setExists(true).setFenced(false).setMasterKey(ByteString.copyFrom((byte[])masterKey)).build();
                if (log.isDebugEnabled()) {
                    log.debug("Inserting new ledger {}", (Object)ledgerId);
                }
            } else {
                byte[] storedMasterKey = ledgerData.getMasterKey().toByteArray();
                if (ArrayUtil.isArrayAllZeros(storedMasterKey)) {
                    ledgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setMasterKey(ByteString.copyFrom((byte[])masterKey)).build();
                    if (log.isDebugEnabled()) {
                        log.debug("Replace old master key {} with new master key {}", (Object)storedMasterKey, (Object)masterKey);
                    }
                } else if (!Arrays.equals(storedMasterKey, masterKey) && !ArrayUtil.isArrayAllZeros(masterKey)) {
                    log.warn("Ledger {} masterKey in db can only be set once.", (Object)ledgerId);
                    throw new IOException(BookieException.create(-100));
                }
            }
            if (this.ledgers.put(ledgerId, ledgerData) == null) {
                this.ledgersCount.incrementAndGet();
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, ledgerData));
            this.pendingDeletedLedgers.remove(ledgerId);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.pendingLedgersUpdates.isEmpty()) {
            return;
        }
        LongWrapper key = LongWrapper.get();
        try {
            Map.Entry<Long, DbLedgerStorageDataFormats.LedgerData> entry;
            int updatedLedgers = 0;
            while ((entry = this.pendingLedgersUpdates.poll()) != null) {
                key.set(entry.getKey());
                byte[] value = entry.getValue().toByteArray();
                this.ledgersDb.put(key.array, value);
                ++updatedLedgers;
            }
            if (log.isDebugEnabled()) {
                log.debug("Persisting updates to {} ledgers", (Object)updatedLedgers);
            }
            this.ledgersDb.sync();
        }
        finally {
            key.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeletedLedgers() throws IOException {
        if (this.pendingDeletedLedgers.isEmpty()) {
            return;
        }
        LongWrapper key = LongWrapper.get();
        try {
            int deletedLedgers = 0;
            for (Long ledgerId : this.pendingDeletedLedgers) {
                key.set(ledgerId);
                this.ledgersDb.delete(key.array);
                ++deletedLedgers;
                this.pendingDeletedLedgers.remove(ledgerId);
            }
            if (log.isDebugEnabled()) {
                log.debug("Persisting deletes of ledgers {}", (Object)deletedLedgers);
            }
            this.ledgersDb.sync();
        }
        finally {
            key.recycle();
        }
    }

    private ReentrantLock lockForLedger(long ledgerId) {
        return this.locks[(int)(Math.abs(ledgerId) % (long)this.locks.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStorageStateFlags() throws IOException {
        LongWrapper keyWrapper = LongWrapper.get();
        LongWrapper currentWrapper = LongWrapper.get();
        try {
            keyWrapper.set(-61181L);
            KeyValueStorage keyValueStorage = this.ledgersDb;
            synchronized (keyValueStorage) {
                int current = 0;
                if (this.ledgersDb.get(keyWrapper.array, currentWrapper.array) >= 0) {
                    current = (int)currentWrapper.getValue();
                }
                int n = current;
                return n;
            }
        }
        finally {
            keyWrapper.recycle();
            currentWrapper.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setStorageStateFlags(int expected, int newFlags) throws IOException {
        LongWrapper keyWrapper = LongWrapper.get();
        LongWrapper currentWrapper = LongWrapper.get();
        LongWrapper newFlagsWrapper = LongWrapper.get();
        try {
            keyWrapper.set(-61181L);
            newFlagsWrapper.set(newFlags);
            KeyValueStorage keyValueStorage = this.ledgersDb;
            synchronized (keyValueStorage) {
                block9: {
                    int current = 0;
                    if (this.ledgersDb.get(keyWrapper.array, currentWrapper.array) >= 0) {
                        current = (int)currentWrapper.getValue();
                    }
                    if (current != expected) break block9;
                    this.ledgersDb.put(keyWrapper.array, newFlagsWrapper.array);
                    this.ledgersDb.sync();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            keyWrapper.recycle();
            currentWrapper.recycle();
            newFlagsWrapper.recycle();
        }
        return false;
    }

    void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        DbLedgerStorageDataFormats.LedgerData ledgerData = this.ledgers.get(ledgerId);
        if (ledgerData != null) {
            DbLedgerStorageDataFormats.LedgerData newLedgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder((DbLedgerStorageDataFormats.LedgerData)ledgerData).setExplicitLac(ByteString.copyFrom((ByteBuffer)lac.nioBuffer())).build();
            if (this.ledgers.put(ledgerId, newLedgerData) == null) {
                this.ledgersCount.incrementAndGet();
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Set explicitLac on ledger {}", (Object)ledgerId);
            }
            this.pendingLedgersUpdates.add(new AbstractMap.SimpleEntry<Long, DbLedgerStorageDataFormats.LedgerData>(ledgerId, newLedgerData));
        }
    }
}

