/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.storage.bookkeeper;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.exceptions.EndOfStreamException;

class DLInputStream {
    private final DistributedLogManager distributedLogManager;
    private final AsyncLogReader reader;

    private DLInputStream(DistributedLogManager distributedLogManager, AsyncLogReader reader) {
        this.distributedLogManager = distributedLogManager;
        this.reader = reader;
    }

    static CompletableFuture<DLInputStream> openReaderAsync(DistributedLogManager distributedLogManager) {
        return distributedLogManager.openAsyncLogReader(DLSN.InitialDLSN).thenApply(r -> new DLInputStream(distributedLogManager, (AsyncLogReader)r));
    }

    CompletableFuture<DLInputStream> readAsync(OutputStream outputStream) {
        CompletableFuture<Void> outputFuture = new CompletableFuture<Void>();
        this.read(outputStream, outputFuture, 10);
        return outputFuture.thenApply(ignore -> this);
    }

    private void read(OutputStream outputStream, CompletableFuture<Void> readFuture, int num) {
        this.reader.readBulk(num).whenComplete((logRecordWithDLSNS, throwable) -> {
            if (null != throwable) {
                if (throwable instanceof EndOfStreamException) {
                    readFuture.complete(null);
                } else {
                    readFuture.completeExceptionally((Throwable)throwable);
                }
                return;
            }
            CompletableFuture.runAsync(() -> logRecordWithDLSNS.forEach(logRecord -> {
                try {
                    outputStream.write(logRecord.getPayload());
                }
                catch (IOException e) {
                    readFuture.completeExceptionally(e);
                }
            })).thenRun(() -> this.read(outputStream, readFuture, num));
        });
    }

    CompletableFuture<Void> closeAsync() {
        return this.reader.asyncClose().thenCompose(ignore -> this.distributedLogManager.asyncClose());
    }
}

