/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class BufferPools {
    private static final AttributeKey<String> POOL_KEY = AttributeKey.stringKey((String)"pool");

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        List<BufferPoolMXBean> bufferBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        return BufferPools.registerObservers(openTelemetry, bufferBeans);
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<BufferPoolMXBean> bufferBeans) {
        if (!SemconvStability.emitOldJvmSemconv()) {
            return Collections.emptyList();
        }
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.buffer.usage").setDescription("Memory that the Java virtual machine is using for this buffer pool").setUnit("By").buildWithCallback(BufferPools.callback(bufferBeans, BufferPoolMXBean::getMemoryUsed)));
        observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.buffer.limit").setDescription("Total capacity of the buffers in this pool").setUnit("By").buildWithCallback(BufferPools.callback(bufferBeans, BufferPoolMXBean::getTotalCapacity)));
        observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.buffer.count").setDescription("The number of buffers in the pool").setUnit("{buffers}").buildWithCallback(BufferPools.callback(bufferBeans, BufferPoolMXBean::getCount)));
        return observables;
    }

    static Consumer<ObservableLongMeasurement> callback(List<BufferPoolMXBean> bufferPools, Function<BufferPoolMXBean, Long> extractor) {
        ArrayList<Attributes> attributeSets = new ArrayList<Attributes>(bufferPools.size());
        for (BufferPoolMXBean pool : bufferPools) {
            attributeSets.add(Attributes.builder().put(POOL_KEY, (Object)pool.getName()).build());
        }
        return measurement -> {
            for (int i = 0; i < bufferPools.size(); ++i) {
                Attributes attributes = (Attributes)attributeSets.get(i);
                long value = (Long)extractor.apply((BufferPoolMXBean)bufferPools.get(i));
                if (value == -1L) continue;
                measurement.record(value, attributes);
            }
        };
    }

    private BufferPools() {
    }
}

