/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Response;

public class PodLogs {
    private ApiClient apiClient;
    private CoreV1Api coreClient;

    public PodLogs() {
        this(Configuration.getDefaultApiClient());
    }

    public PodLogs(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.coreClient = new CoreV1Api(apiClient);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public InputStream streamNamespacedPodLog(V1Pod pod) throws ApiException, IOException {
        if (pod.getSpec() == null) {
            throw new ApiException("pod.spec is null and container isn't specified.");
        }
        if (pod.getSpec().getContainers() == null || pod.getSpec().getContainers().size() < 1) {
            throw new ApiException("pod.spec.containers has no containers");
        }
        return this.streamNamespacedPodLog(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), ((V1Container)pod.getSpec().getContainers().get(0)).getName());
    }

    public InputStream streamNamespacedPodLog(String namespace, String name, String container) throws ApiException, IOException {
        return this.streamNamespacedPodLog(namespace, name, container, null, null, false);
    }

    public InputStream streamNamespacedPodLog(String namespace, String name, String container, Integer sinceSeconds, Integer tailLines, boolean timestamps) throws ApiException, IOException {
        Call call = this.coreClient.readNamespacedPodLogCall(name, namespace, container, Boolean.valueOf(true), null, null, "false", Boolean.valueOf(false), sinceSeconds, tailLines, Boolean.valueOf(timestamps), null);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            if (response.body() != null) {
                response.close();
            }
            throw new ApiException(response.code(), "Logs request failed: " + response.code());
        }
        return response.body().byteStream();
    }
}

