/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.opentelemetry.api.common.Attributes;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Batch;
import io.streamnative.oxia.client.batch.BatchFactory;
import io.streamnative.oxia.client.batch.WriteBatch;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.metrics.InstrumentProvider;
import io.streamnative.oxia.client.metrics.LatencyHistogram;
import io.streamnative.oxia.client.session.SessionManager;
import lombok.NonNull;

class WriteBatchFactory
extends BatchFactory {
    @NonNull
    final SessionManager sessionManager;
    final LatencyHistogram writeRequestLatencyHistogram;

    public WriteBatchFactory(@NonNull OxiaStubProvider stubProvider, @NonNull SessionManager sessionManager, @NonNull ClientConfig config, @NonNull InstrumentProvider instrumentProvider) {
        super(stubProvider, config);
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.sessionManager = sessionManager;
        this.writeRequestLatencyHistogram = instrumentProvider.newLatencyHistogram("oxia.client.ops.req", "The latency of a get batch request to the server", Attributes.builder().put("oxia.batch.type", "write").build());
    }

    @Override
    public Batch getBatch(long shardId) {
        return new WriteBatch(this, this.stubProvider, this.sessionManager, shardId, this.getConfig().maxBatchSize());
    }
}

