/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.cache.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.Stat;

public class JSONMetadataSerdeTypeRef<T>
implements MetadataSerde<T> {
    private final ObjectReader objectReader;
    private final ObjectWriter objectWriter;

    public JSONMetadataSerdeTypeRef(TypeReference<T> typeRef) {
        this.objectReader = ObjectMapperFactory.getMapper().reader().forType(typeRef);
        this.objectWriter = ObjectMapperFactory.getMapper().writer().forType(typeRef);
    }

    @Override
    public byte[] serialize(String path, T value) throws IOException {
        return this.objectWriter.writeValueAsBytes(value);
    }

    @Override
    public T deserialize(String path, byte[] content, Stat stat) throws IOException {
        return (T)this.objectReader.readValue(content);
    }
}

