/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.namespace.NamespaceBundleOwnershipListener;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.events.TopicPoliciesEvent;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.FutureUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTopicBasedTopicPoliciesService
implements TopicPoliciesService {
    private final PulsarService pulsarService;
    private final HashSet localCluster;
    private final String clusterName;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ConcurrentInitializer<NamespaceEventsSystemTopicFactory> namespaceEventsSystemTopicFactoryLazyInitializer = new LazyInitializer<NamespaceEventsSystemTopicFactory>(){

        protected NamespaceEventsSystemTopicFactory initialize() {
            try {
                return new NamespaceEventsSystemTopicFactory(SystemTopicBasedTopicPoliciesService.this.pulsarService.getClient());
            }
            catch (PulsarServerException e) {
                log.error("Create namespace event system topic factory error.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    @VisibleForTesting
    final Map<TopicName, TopicPolicies> policiesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    final Map<TopicName, TopicPolicies> globalPoliciesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    private final Map<NamespaceName, AtomicInteger> ownedBundlesCountPerNamespace = new ConcurrentHashMap<NamespaceName, AtomicInteger>();
    private final Map<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>> readerCaches = new ConcurrentHashMap<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>>();
    final Map<NamespaceName, CompletableFuture<Void>> policyCacheInitMap = new ConcurrentHashMap<NamespaceName, CompletableFuture<Void>>();
    @VisibleForTesting
    final Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> listeners = new ConcurrentHashMap<TopicName, List<TopicPolicyListener<TopicPolicies>>>();
    private final AsyncLoadingCache<NamespaceName, SystemTopicClient.Writer<PulsarEvent>> writerCaches;
    private static final Logger log = LoggerFactory.getLogger(SystemTopicBasedTopicPoliciesService.class);

    public SystemTopicBasedTopicPoliciesService(PulsarService pulsarService) {
        this.pulsarService = pulsarService;
        this.clusterName = pulsarService.getConfiguration().getClusterName();
        this.localCluster = Sets.newHashSet((Object[])new String[]{this.clusterName});
        this.writerCaches = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((namespaceName, writer, cause) -> {
            try {
                ((SystemTopicClient.Writer)writer).close();
            }
            catch (Exception e) {
                log.error("[{}] Close writer error.", namespaceName, (Object)e);
            }
        }).executor((Executor)pulsarService.getExecutor()).buildAsync((namespaceName, executor) -> {
            if (this.closed.get()) {
                return CompletableFuture.failedFuture(new BrokerServiceException(this.getClass().getName() + " is closed."));
            }
            TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient((NamespaceName)namespaceName);
            return systemTopicClient.newWriterAsync();
        });
    }

    @Override
    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject())) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName changeEvents = NamespaceEventsSystemTopicFactory.getEventsTopicName(topicName.getNamespaceObject());
        CompletionStage changeEventTopicExists = this.pulsarService.getPulsarResources().getTopicResources().persistentTopicExists(changeEvents).thenCompose(nonPartitionedExists -> {
            if (!nonPartitionedExists.booleanValue()) {
                return this.pulsarService.getPulsarResources().getTopicResources().persistentTopicExists(changeEvents.getPartition(0));
            }
            return CompletableFuture.completedFuture(true);
        });
        return ((CompletableFuture)changeEventTopicExists).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                log.info("Skip delete topic-level policies because {} has been removed before", (Object)changeEvents);
                return CompletableFuture.completedFuture(null);
            }
            return this.sendTopicPolicyEvent(topicName, ActionType.DELETE, null);
        });
    }

    @Override
    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject())) {
            return CompletableFuture.failedFuture(new BrokerServiceException.NotAllowedException("Not allowed to update topic policy for the heartbeat topic"));
        }
        return this.sendTopicPolicyEvent(topicName, ActionType.UPDATE, policies);
    }

    private CompletableFuture<Void> sendTopicPolicyEvent(TopicName topicName, ActionType actionType, @Nullable TopicPolicies policies) {
        return this.pulsarService.getPulsarResources().getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenCompose(namespacePolicies -> {
            if (namespacePolicies.isPresent() && ((Policies)namespacePolicies.get()).deleted) {
                log.debug("[{}] skip sending topic policy event since the namespace is deleted", (Object)topicName);
                return CompletableFuture.completedFuture(null);
            }
            try {
                this.createSystemTopicFactoryIfNeeded();
            }
            catch (PulsarServerException e) {
                return CompletableFuture.failedFuture(e);
            }
            CompletableFuture result = new CompletableFuture();
            this.writerCaches.get((Object)topicName.getNamespaceObject()).whenComplete((writer, cause) -> {
                if (cause != null) {
                    this.writerCaches.synchronous().invalidate((Object)topicName.getNamespaceObject());
                    result.completeExceptionally((Throwable)cause);
                } else {
                    CompletableFuture<MessageId> writeFuture = this.sendTopicPolicyEventInternal(topicName, actionType, (SystemTopicClient.Writer<PulsarEvent>)writer, policies);
                    writeFuture.whenComplete((messageId, e) -> {
                        if (e != null) {
                            result.completeExceptionally((Throwable)e);
                        } else if (messageId != null) {
                            result.complete(null);
                        } else {
                            result.completeExceptionally(new RuntimeException("Got message id is null."));
                        }
                    });
                }
            });
            return result;
        });
    }

    private CompletableFuture<MessageId> sendTopicPolicyEventInternal(TopicName topicName, ActionType actionType, SystemTopicClient.Writer<PulsarEvent> writer, @Nullable TopicPolicies policies) {
        PulsarEvent event = this.getPulsarEvent(topicName, actionType, policies);
        if (!ActionType.DELETE.equals((Object)actionType)) {
            return writer.writeAsync(TopicPoliciesService.getEventKey(event, policies != null && policies.isGlobalPolicies()), event);
        }
        CompletionStage deletePolicies = writer.deleteAsync(TopicPoliciesService.getEventKey(event, true), event).thenCompose(__ -> writer.deleteAsync(TopicPoliciesService.getEventKey(event, false), event));
        ((CompletableFuture)deletePolicies).exceptionally(ex -> {
            log.error("Failed to delete topic policy [{}] error.", (Object)topicName, ex);
            return null;
        });
        return deletePolicies;
    }

    private PulsarEvent getPulsarEvent(TopicName topicName, ActionType actionType, TopicPolicies policies) {
        PulsarEvent.PulsarEventBuilder builder = PulsarEvent.builder();
        if (policies == null || !policies.isGlobalPolicies()) {
            builder.replicateTo(this.localCluster);
        }
        return builder.actionType(actionType).eventType(EventType.TOPIC_POLICY).topicPoliciesEvent(TopicPoliciesEvent.builder().domain(topicName.getDomain().toString()).tenant(topicName.getTenant()).namespace(topicName.getNamespaceObject().getLocalName()).topic(TopicName.get((String)topicName.getPartitionedTopicName()).getLocalName()).policies(policies).build()).build();
    }

    private void notifyListener(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            TopicName topicName = TopicName.get((String)TopicPoliciesService.unwrapEventKey(msg.getKey()).getPartitionedTopicName());
            if (this.listeners.get(topicName) != null) {
                for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                    try {
                        listener.onUpdate(null);
                    }
                    catch (Throwable error) {
                        log.error("[{}] call listener error.", (Object)topicName, (Object)error);
                    }
                }
            }
            return;
        }
        if (!EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            return;
        }
        TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
        TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
        if (this.listeners.get(topicName) != null) {
            TopicPolicies policies = event.getPolicies();
            for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                try {
                    listener.onUpdate(policies);
                }
                catch (Throwable error) {
                    log.error("[{}] call listener error.", (Object)topicName, (Object)error);
                }
            }
        }
    }

    @Override
    public TopicPolicies getTopicPolicies(TopicName topicName) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
        return this.getTopicPolicies(topicName, false);
    }

    @Override
    public TopicPolicies getTopicPolicies(TopicName topicName, boolean isGlobal) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject())) {
            return null;
        }
        if (!this.policyCacheInitMap.containsKey(topicName.getNamespaceObject())) {
            NamespaceName namespace = topicName.getNamespaceObject();
            this.prepareInitPoliciesCacheAsync(namespace);
        }
        MutablePair result = new MutablePair();
        this.policyCacheInitMap.compute(topicName.getNamespaceObject(), (k, initialized) -> {
            if (initialized == null || !initialized.isDone()) {
                result.setLeft((Object)new BrokerServiceException.TopicPoliciesCacheNotInitException());
            } else {
                TopicPolicies topicPolicies = isGlobal ? this.globalPoliciesCache.get(TopicName.get((String)topicName.getPartitionedTopicName())) : this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
                result.setRight((Object)topicPolicies);
            }
            return initialized;
        });
        if (result.getLeft() != null) {
            throw (BrokerServiceException.TopicPoliciesCacheNotInitException)result.getLeft();
        }
        return (TopicPolicies)result.getRight();
    }

    @Override
    public @NonNull CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(@NonNull TopicName topicName, boolean isGlobal) {
        Objects.requireNonNull(topicName);
        NamespaceName namespace = topicName.getNamespaceObject();
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)namespace) || SystemTopicBasedTopicPoliciesService.isSelf(topicName)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        LoadManager loadManager = this.pulsarService.getLoadManager().get();
        if (loadManager == null || !loadManager.started() || this.closed.get()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Void> preparedFuture = this.prepareInitPoliciesCacheAsync(topicName.getNamespaceObject());
        return preparedFuture.thenApply(__ -> {
            TopicPolicies candidatePolicies = isGlobal ? this.globalPoliciesCache.get(TopicName.get((String)topicName.getPartitionedTopicName())) : this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
            return Optional.ofNullable(candidatePolicies);
        });
    }

    @Override
    public @NonNull CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(@NonNull TopicName topicName) {
        Objects.requireNonNull(topicName);
        CompletableFuture<Void> preparedFuture = this.prepareInitPoliciesCacheAsync(topicName.getNamespaceObject());
        return preparedFuture.thenApply(__ -> {
            TopicPolicies localPolicies = this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
            if (localPolicies != null) {
                return Optional.of(localPolicies);
            }
            return Optional.ofNullable(this.globalPoliciesCache.get(TopicName.get((String)topicName.getPartitionedTopicName())));
        });
    }

    @Override
    public TopicPolicies getTopicPoliciesIfExists(TopicName topicName) {
        return this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
    }

    @Override
    public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName topicName) {
        CompletableFuture<TopicPolicies> result = new CompletableFuture<TopicPolicies>();
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException e) {
            result.complete(null);
            return result;
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
        systemTopicClient.newReaderAsync().thenAccept(r -> this.fetchTopicPoliciesAsyncAndCloseReader((SystemTopicClient.Reader<PulsarEvent>)r, topicName, null, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.isHeartbeatNamespace((ServiceUnitId)namespace)) {
            return CompletableFuture.completedFuture(null);
        }
        SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService = this;
        synchronized (systemTopicBasedTopicPoliciesService) {
            if (this.readerCaches.get(namespace) != null) {
                this.ownedBundlesCountPerNamespace.get(namespace).incrementAndGet();
                return CompletableFuture.completedFuture(null);
            }
            return this.prepareInitPoliciesCacheAsync(namespace);
        }
    }

    @VisibleForTesting
    @NonNull CompletableFuture<Void> prepareInitPoliciesCacheAsync(@NonNull NamespaceName namespace) {
        Objects.requireNonNull(namespace);
        if (this.closed.get()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.pulsarService.getPulsarResources().getNamespaceResources().getPoliciesAsync(namespace).thenCompose(namespacePolicies -> {
            if (namespacePolicies.isEmpty() || ((Policies)namespacePolicies.get()).deleted) {
                log.info("[{}] skip prepare init policies cache since the namespace is deleted", (Object)namespace);
                return CompletableFuture.completedFuture(null);
            }
            return this.policyCacheInitMap.computeIfAbsent(namespace, k -> {
                CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerCompletableFuture = this.createSystemTopicClient(namespace);
                this.readerCaches.put(namespace, readerCompletableFuture);
                this.ownedBundlesCountPerNamespace.putIfAbsent(namespace, new AtomicInteger(1));
                CompletionStage initFuture = readerCompletableFuture.thenCompose(reader -> {
                    CompletableFuture<Void> stageFuture = new CompletableFuture<Void>();
                    this.initPolicesCache((SystemTopicClient.Reader<PulsarEvent>)reader, stageFuture);
                    return stageFuture.thenAccept(__ -> this.readMorePoliciesAsync((SystemTopicClient.Reader<PulsarEvent>)reader));
                });
                ((CompletableFuture)initFuture).exceptionally(ex -> {
                    try {
                        if (this.closed.get()) {
                            return null;
                        }
                        log.error("[{}] Failed to create reader on __change_events topic", (Object)namespace, ex);
                        this.cleanCacheAndCloseReader(namespace, false);
                    }
                    catch (Throwable cleanupEx) {
                        log.error("[{}] Failed to cleanup reader on __change_events topic", (Object)namespace, (Object)cleanupEx);
                    }
                    return null;
                });
                return initFuture;
            });
        });
    }

    protected CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> createSystemTopicClient(NamespaceName namespace) {
        if (this.closed.get()) {
            return CompletableFuture.failedFuture(new BrokerServiceException(this.getClass().getName() + " is closed."));
        }
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException ex) {
            return FutureUtil.failedFuture((Throwable)ex);
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient(namespace);
        return systemTopicClient.newReaderAsync();
    }

    @Override
    public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.checkHeartbeatNamespace((ServiceUnitId)namespace) != null || NamespaceService.checkHeartbeatNamespaceV2((ServiceUnitId)namespace) != null) {
            return CompletableFuture.completedFuture(null);
        }
        AtomicInteger bundlesCount = this.ownedBundlesCountPerNamespace.get(namespace);
        if (bundlesCount == null || bundlesCount.decrementAndGet() <= 0) {
            this.cleanCacheAndCloseReader(namespace, true, true);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void start() {
        this.pulsarService.getNamespaceService().addNamespaceBundleOwnershipListener(new NamespaceBundleOwnershipListener(){

            @Override
            public void onLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.addOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public void unLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.removeOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public boolean test(NamespaceBundle namespaceBundle) {
                return true;
            }
        });
    }

    private void initPolicesCache(SystemTopicClient.Reader<PulsarEvent> reader, CompletableFuture<Void> future) {
        if (this.closed.get()) {
            future.completeExceptionally(new BrokerServiceException(this.getClass().getName() + " is closed."));
            this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
            return;
        }
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to check the move events for the system topic", (Object)reader.getSystemTopic().getTopicName(), ex);
                future.completeExceptionally((Throwable)ex);
                this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
                return;
            }
            if (hasMore.booleanValue()) {
                ((CompletableFuture)reader.readNextAsync().thenAccept(msg -> {
                    this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Loop next event reading for system topic.", (Object)reader.getSystemTopic().getTopicName().getNamespaceObject());
                    }
                    this.initPolicesCache(reader, future);
                })).exceptionally(e -> {
                    log.error("[{}] Failed to read event from the system topic.", (Object)reader.getSystemTopic().getTopicName(), e);
                    future.completeExceptionally((Throwable)e);
                    this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
                    return null;
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Reach the end of the system topic.", (Object)reader.getSystemTopic().getTopicName());
                }
                this.policiesCache.forEach((topicName, topicPolicies) -> {
                    if (this.listeners.get(topicName) != null) {
                        for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                            try {
                                listener.onUpdate((TopicPolicies)topicPolicies);
                            }
                            catch (Throwable error) {
                                log.error("[{}] call listener error.", topicName, (Object)error);
                            }
                        }
                    }
                });
                future.complete(null);
            }
        });
    }

    private void cleanCacheAndCloseReader(@NonNull NamespaceName namespace, boolean cleanOwnedBundlesCount) {
        this.cleanCacheAndCloseReader(namespace, cleanOwnedBundlesCount, false);
    }

    private void cleanCacheAndCloseReader(@NonNull NamespaceName namespace, boolean cleanOwnedBundlesCount, boolean cleanWriterCache) {
        if (cleanWriterCache) {
            this.writerCaches.synchronous().invalidate((Object)namespace);
        }
        CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerFuture = this.readerCaches.remove(namespace);
        if (cleanOwnedBundlesCount) {
            this.ownedBundlesCountPerNamespace.remove(namespace);
        }
        if (readerFuture != null && !readerFuture.isCompletedExceptionally()) {
            ((CompletableFuture)readerFuture.thenCompose(SystemTopicClient.Reader::closeAsync)).exceptionally(ex -> {
                log.warn("[{}] Close change_event reader fail.", (Object)namespace, ex);
                return null;
            });
        }
        this.policyCacheInitMap.compute(namespace, (k, v) -> {
            this.policiesCache.entrySet().removeIf(entry -> Objects.equals(((TopicName)entry.getKey()).getNamespaceObject(), namespace));
            return null;
        });
    }

    private void readMorePoliciesAsync(SystemTopicClient.Reader<PulsarEvent> reader) {
        if (this.closed.get()) {
            this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
            return;
        }
        ((CompletableFuture)reader.readNextAsync().thenAccept(msg -> {
            this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
            this.notifyListener((Message<PulsarEvent>)msg);
        })).whenComplete((__, ex) -> {
            if (ex == null) {
                this.readMorePoliciesAsync(reader);
            } else {
                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (cause instanceof PulsarClientException.AlreadyClosedException) {
                    log.info("Closing the topic policies reader for {}", (Object)reader.getSystemTopic().getTopicName());
                    this.cleanCacheAndCloseReader(reader.getSystemTopic().getTopicName().getNamespaceObject(), false);
                } else {
                    log.warn("Read more topic polices exception, read again.", ex);
                    this.readMorePoliciesAsync(reader);
                }
            }
        });
    }

    private void refreshTopicPoliciesCache(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            boolean isGlobalPolicy = TopicPoliciesService.isGlobalPolicy(msg);
            TopicName topicName = TopicName.get((String)TopicPoliciesService.unwrapEventKey(msg.getKey()).getPartitionedTopicName());
            if (isGlobalPolicy) {
                this.globalPoliciesCache.remove(topicName);
            } else {
                this.policiesCache.remove(topicName);
            }
            return;
        }
        if (EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
            TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
            switch (((PulsarEvent)msg.getValue()).getActionType()) {
                case INSERT: {
                    TopicPolicies old;
                    TopicPolicies topicPolicies = old = event.getPolicies().isGlobalPolicies() ? this.globalPoliciesCache.putIfAbsent(topicName, event.getPolicies()) : this.policiesCache.putIfAbsent(topicName, event.getPolicies());
                    if (old == null) break;
                    log.warn("Policy insert failed, the topic: {} policy already exist", (Object)topicName);
                    break;
                }
                case UPDATE: {
                    if (event.getPolicies().isGlobalPolicies()) {
                        this.globalPoliciesCache.put(topicName, event.getPolicies());
                        break;
                    }
                    this.policiesCache.put(topicName, event.getPolicies());
                    break;
                }
                case DELETE: {
                    this.policiesCache.remove(topicName);
                    try {
                        this.createSystemTopicFactoryIfNeeded();
                    }
                    catch (PulsarServerException e) {
                        log.error("Failed to create system topic factory");
                        break;
                    }
                    TopicPoliciesSystemTopicClient systemTopicClient = this.getNamespaceEventsSystemTopicFactory().createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
                    systemTopicClient.newWriterAsync().thenAccept(writer -> this.sendTopicPolicyEventInternal(topicName, ActionType.DELETE, (SystemTopicClient.Writer<PulsarEvent>)writer, event.getPolicies()).whenComplete((result, e) -> writer.closeAsync().whenComplete((res, ex) -> {
                        if (ex != null) {
                            log.error("close writer failed ", ex);
                        }
                    })));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    log.warn("Unknown event action type: {}", (Object)((PulsarEvent)msg.getValue()).getActionType());
                }
            }
        }
    }

    private boolean hasReplicateTo(Message<?> message) {
        if (message instanceof MessageImpl) {
            return ((MessageImpl)message).hasReplicateTo() ? (((MessageImpl)message).getReplicateTo().size() == 1 ? !((MessageImpl)message).getReplicateTo().contains(this.clusterName) : true) : false;
        }
        if (message instanceof TopicMessageImpl) {
            return this.hasReplicateTo(((TopicMessageImpl)message).getMessage());
        }
        return false;
    }

    private void createSystemTopicFactoryIfNeeded() throws PulsarServerException {
        try {
            this.getNamespaceEventsSystemTopicFactory();
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    private NamespaceEventsSystemTopicFactory getNamespaceEventsSystemTopicFactory() {
        try {
            return (NamespaceEventsSystemTopicFactory)this.namespaceEventsSystemTopicFactoryLazyInitializer.get();
        }
        catch (Exception e) {
            log.error("Create namespace event system topic factory error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void fetchTopicPoliciesAsyncAndCloseReader(SystemTopicClient.Reader<PulsarEvent> reader, TopicName topicName, TopicPolicies policies, CompletableFuture<TopicPolicies> future) {
        if (this.closed.get()) {
            future.completeExceptionally(new BrokerServiceException(this.getClass().getName() + " is closed."));
            reader.closeAsync().whenComplete((v, e) -> {
                if (e != null) {
                    log.error("[{}] Close reader error.", (Object)topicName, e);
                }
            });
            return;
        }
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            }
            if (hasMore != null && hasMore.booleanValue()) {
                reader.readNextAsync().whenComplete((msg, e) -> {
                    if (e != null) {
                        future.completeExceptionally((Throwable)e);
                    }
                    if (msg.getValue() != null && EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
                        TopicPoliciesEvent topicPoliciesEvent = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
                        if (topicName.equals((Object)TopicName.get((String)topicPoliciesEvent.getDomain(), (String)topicPoliciesEvent.getTenant(), (String)topicPoliciesEvent.getNamespace(), (String)topicPoliciesEvent.getTopic()))) {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, topicPoliciesEvent.getPolicies(), future);
                        } else {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, policies, future);
                        }
                    } else {
                        future.complete(null);
                    }
                });
            } else {
                if (!future.isDone()) {
                    future.complete(policies);
                }
                reader.closeAsync().whenComplete((v, e) -> {
                    if (e != null) {
                        log.error("[{}] Close reader error.", (Object)topicName, e);
                    }
                });
            }
        });
    }

    @VisibleForTesting
    long getPoliciesCacheSize() {
        return this.policiesCache.size();
    }

    @VisibleForTesting
    long getReaderCacheCount() {
        return this.readerCaches.size();
    }

    @VisibleForTesting
    boolean checkReaderIsCached(NamespaceName namespaceName) {
        return this.readerCaches.get(namespaceName) != null;
    }

    @VisibleForTesting
    public CompletableFuture<Void> getPoliciesCacheInit(NamespaceName namespaceName) {
        return this.policyCacheInitMap.get(namespaceName);
    }

    @Override
    public void registerListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners == null) {
                topicListeners = new CopyOnWriteArrayList<TopicPolicyListener>();
            }
            topicListeners.add(listener);
            return topicListeners;
        });
    }

    @Override
    public void unregisterListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners != null) {
                topicListeners.remove(listener);
                if (topicListeners.isEmpty()) {
                    topicListeners = null;
                }
            }
            return topicListeners;
        });
    }

    @VisibleForTesting
    protected Map<TopicName, TopicPolicies> getPoliciesCache() {
        return this.policiesCache;
    }

    @VisibleForTesting
    protected Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> getListeners() {
        return this.listeners;
    }

    @VisibleForTesting
    protected AsyncLoadingCache<NamespaceName, SystemTopicClient.Writer<PulsarEvent>> getWriterCaches() {
        return this.writerCaches;
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.writerCaches.synchronous().invalidateAll();
            this.readerCaches.values().forEach(future -> {
                try {
                    SystemTopicClient.Reader reader = future.getNow(null);
                    if (reader != null) {
                        reader.close();
                        log.info("Closed the reader for topic policies");
                    } else {
                        ((CompletableFuture)future.thenAccept(SystemTopicClient.Reader::closeAsync)).whenComplete((__, e) -> {
                            if (e == null) {
                                log.info("Closed the reader for topic policies");
                            } else {
                                log.error("Failed to close the reader for topic policies", e);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.readerCaches.clear();
        }
    }

    private static boolean isSelf(TopicName topicName) {
        String localName = topicName.getLocalName();
        if (!topicName.isPartitioned()) {
            return localName.equals("__change_events");
        }
        int index = localName.lastIndexOf("-partition-");
        return localName.substring(0, index).equals("__change_events");
    }
}

