/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Markers;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPersistentReplicator
extends PersistentReplicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoPersistentReplicator.class);

    public GeoPersistentReplicator(PersistentTopic topic, ManagedCursor cursor, String localCluster, String remoteCluster, BrokerService brokerService, PulsarClientImpl replicationClient) throws PulsarServerException {
        super(localCluster, topic, cursor, remoteCluster, topic.getName(), brokerService, replicationClient);
    }

    @Override
    protected String getProducerName() {
        return GeoPersistentReplicator.getReplicatorName(this.replicatorPrefix, this.localCluster) + "-->" + this.remoteCluster;
    }

    @Override
    protected CompletableFuture<Void> prepareCreateProducer() {
        if (this.brokerService.getPulsar().getConfig().isCreateTopicToRemoteClusterForReplication()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> topicCheckFuture = new CompletableFuture<Void>();
        this.replicationClient.getPartitionedTopicMetadata(this.localTopic.getName(), false, false).whenComplete((metadata, ex) -> {
            if (ex == null) {
                if (metadata.partitions == 0) {
                    topicCheckFuture.complete(null);
                } else {
                    String errorMsg = String.format("{} Can not create the replicator due to the partitions in the remote cluster is not 0, but is %s", this.replicatorId, metadata.partitions);
                    log.error(errorMsg);
                    topicCheckFuture.completeExceptionally((Throwable)new PulsarClientException.NotAllowedException(errorMsg));
                }
            } else {
                topicCheckFuture.completeExceptionally(FutureUtil.unwrapCompletionException((Throwable)ex));
            }
        });
        return topicCheckFuture;
    }

    @Override
    protected boolean replicateEntries(List<Entry> entries, PersistentReplicator.InFlightTask inFlightTask) {
        boolean atLeastOneMessageSentForReplication = false;
        boolean isEnableReplicatedSubscriptions = this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions();
        try {
            boolean isLocalMessageSkippedOnce = false;
            boolean skipRemainingMessages = inFlightTask.isSkipReadResultDueToCursorRewind();
            for (int i = 0; i < entries.size(); ++i) {
                TxnID tx;
                MessageImpl msg;
                Entry entry = entries.get(i);
                if (skipRemainingMessages) {
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    continue;
                }
                int length = entry.getLength();
                ByteBuf headersAndPayload = entry.getDataBuffer();
                try {
                    msg = MessageImpl.deserializeSkipBrokerEntryMetaData((ByteBuf)headersAndPayload);
                }
                catch (Throwable t) {
                    log.error("[{}] Failed to deserialize message at {} (buffer size: {}): {}", new Object[]{this.replicatorId, entry.getPosition(), length, t.getMessage(), t});
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    continue;
                }
                if (Markers.isTxnMarker((MessageMetadata)msg.getMessageBuilder())) {
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (msg.getMessageBuilder().hasTxnidLeastBits() && msg.getMessageBuilder().hasTxnidMostBits() && this.topic.isTxnAborted(tx = new TxnID(msg.getMessageBuilder().getTxnidMostBits(), msg.getMessageBuilder().getTxnidLeastBits()), (PositionImpl)entry.getPosition())) {
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (isEnableReplicatedSubscriptions) {
                    this.checkReplicatedSubscriptionMarker(entry.getPosition(), msg, headersAndPayload);
                }
                if (msg.isReplicated()) {
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (msg.hasReplicateTo() && !msg.getReplicateTo().contains(this.remoteCluster)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Skipping message at position {}, replicateTo {}", new Object[]{this.replicatorId, entry.getPosition(), msg.getReplicateTo()});
                    }
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (msg.isExpired(this.messageTTLInSeconds)) {
                    this.msgExpired.recordEvent(0L);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Discarding expired message at position {}, replicateTo {}", new Object[]{this.replicatorId, entry.getPosition(), msg.getReplicateTo()});
                    }
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (STATE_UPDATER.get(this) != AbstractReplicator.State.Started || isLocalMessageSkippedOnce) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Dropping read message at {} because producer is not ready", (Object)this.replicatorId, (Object)entry.getPosition());
                    }
                    isLocalMessageSkippedOnce = true;
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                this.dispatchRateLimiter.ifPresent(rateLimiter -> rateLimiter.consumeDispatchQuota(1L, entry.getLength()));
                msg.setReplicatedFrom(this.localCluster);
                headersAndPayload.retain();
                CompletableFuture<SchemaInfo> schemaFuture = this.getSchemaInfo(msg);
                if (!schemaFuture.isDone() || schemaFuture.isCompletedExceptionally()) {
                    this.beforeTerminateOrCursorRewinding(PersistentReplicator.ReasonOfWaitForCursorRewinding.Fetching_Schema);
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    headersAndPayload.release();
                    msg.recycle();
                    skipRemainingMessages = true;
                    log.info("[{}] Pause the data replication due to new detected schema", (Object)this.replicatorId);
                    schemaFuture.whenComplete((__, e) -> {
                        if (e != null) {
                            log.warn("[{}] Failed to get schema from local cluster, will try in the next loop", (Object)this.replicatorId, e);
                        }
                        log.info("[{}] Resume the data replication after the schema fetching done", (Object)this.replicatorId);
                        this.doRewindCursor(true);
                    });
                    continue;
                }
                msg.setSchemaInfoForReplicator(schemaFuture.get());
                msg.getMessageBuilder().clearTxnidMostBits();
                msg.getMessageBuilder().clearTxnidLeastBits();
                msg.getMessageBuilder().addProperty().setKey("__MSG_PROP_REPL_SOURCE_POSITION").setValue(String.format("%s:%s", entry.getLedgerId(), entry.getEntryId()));
                this.msgOut.recordEvent((long)headersAndPayload.readableBytes());
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Publishing {}:{}", new Object[]{this.replicatorId, entry.getLedgerId(), entry.getEntryId()});
                }
                this.producer.sendAsync((Message)msg, (SendCallback)PersistentReplicator.ProducerSendCallback.create(this, entry, msg, inFlightTask));
                atLeastOneMessageSentForReplication = true;
            }
        }
        catch (Exception e2) {
            log.error("[{}] Unexpected exception in replication task: {}", new Object[]{this.replicatorId, e2.getMessage(), e2});
        }
        return atLeastOneMessageSentForReplication;
    }
}

