/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.batching;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.metadata.api.MetadataNodeSizeStats;
import org.apache.pulsar.metadata.impl.batching.MetadataOp;
import org.apache.pulsar.metadata.impl.batching.MetadataStoreBatchStrategy;
import org.apache.zookeeper.ZooKeeper;
import org.jctools.queues.MessagePassingQueue;

public class ZKMetadataStoreBatchStrategy
implements MetadataStoreBatchStrategy {
    public static final int ZK_RESPONSE_HEADER_LEN = 88;
    private final int defaultSize;
    private final int maxOperations;
    private final int maxGetSize;
    private final int maxPutSize;
    private final MetadataNodeSizeStats nodeSizeStats;

    public ZKMetadataStoreBatchStrategy(MetadataNodeSizeStats nodeSizeStats, int maxOperations, int defaultMaxSize, ZooKeeper zkc) {
        int maxSizeConfigured = zkc.getClientConfig().getInt("jute.maxbuffer", 1048575);
        maxSizeConfigured = maxSizeConfigured > 0 ? maxSizeConfigured : defaultMaxSize;
        this.maxOperations = maxOperations;
        this.maxGetSize = maxSizeConfigured;
        this.maxPutSize = maxSizeConfigured;
        this.nodeSizeStats = nodeSizeStats;
        this.defaultSize = Math.max(this.maxPutSize >>> 4, 1024);
    }

    public int maxSize() {
        return this.maxPutSize;
    }

    @Override
    public List<MetadataOp> nextBatch(MessagePassingQueue<MetadataOp> opsSrc) {
        MetadataOp op;
        int requestSize = 0;
        int estimatedResponseSize = 0;
        int maxGetSize = this.maxGetSize >>> 1;
        ArrayList<MetadataOp> ops = new ArrayList<MetadataOp>();
        while (!opsSrc.isEmpty() && (op = (MetadataOp)opsSrc.peek()) != null) {
            MetadataOp.Type type = op.getType();
            String path = op.getPath();
            switch (type) {
                case GET_CHILDREN: {
                    estimatedResponseSize += 88;
                    int childrenCount = this.nodeSizeStats.getMaxChildrenCountOfSameResourceType(path);
                    if (childrenCount < 0) {
                        estimatedResponseSize += this.defaultSize;
                        break;
                    }
                    int size = this.nodeSizeStats.getMaxSizeOfSameResourceType(path);
                    if (size > 0) {
                        estimatedResponseSize += childrenCount * (size + 4);
                        break;
                    }
                    estimatedResponseSize += childrenCount * (this.defaultSize + 4);
                    break;
                }
                case GET: {
                    estimatedResponseSize += 88;
                    int size = this.nodeSizeStats.getMaxSizeOfSameResourceType(path);
                    if (size > 0) {
                        estimatedResponseSize += size;
                        break;
                    }
                    estimatedResponseSize += this.defaultSize;
                    break;
                }
                case DELETE: 
                case PUT: {
                    requestSize += op.size();
                    estimatedResponseSize += 88;
                    estimatedResponseSize += path.length();
                    break;
                }
                default: {
                    estimatedResponseSize += 88;
                    estimatedResponseSize += path.length();
                }
            }
            if (!ops.isEmpty() && (estimatedResponseSize > maxGetSize || requestSize > this.maxPutSize)) break;
            ops.add((MetadataOp)opsSrc.poll());
            if (ops.size() != this.maxOperations) continue;
            break;
        }
        return ops;
    }
}

