/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.util.List;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.IncludeExclude;

public class GzipHandlerUtil {
    public static Handler wrapWithGzipHandler(Handler innerHandler, List<String> gzipCompressionExcludedPaths) {
        Handler wrappedHandler;
        if (GzipHandlerUtil.isGzipCompressionCompletelyDisabled(gzipCompressionExcludedPaths)) {
            wrappedHandler = innerHandler;
        } else {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler(innerHandler);
            if (gzipCompressionExcludedPaths != null && gzipCompressionExcludedPaths.size() > 0) {
                gzipHandler.setExcludedPaths(gzipCompressionExcludedPaths.toArray(new String[0]));
            }
            wrappedHandler = gzipHandler;
        }
        return wrappedHandler;
    }

    public static boolean isGzipCompressionCompletelyDisabled(List<String> gzipCompressionExcludedPaths) {
        return gzipCompressionExcludedPaths != null && gzipCompressionExcludedPaths.size() == 1 && (gzipCompressionExcludedPaths.get(0).equals("^.*") || gzipCompressionExcludedPaths.get(0).equals("^.*$"));
    }

    public static boolean isGzipCompressionEnabledForEndpoint(List<String> gzipCompressionExcludedPaths, String endpoint) {
        if (gzipCompressionExcludedPaths == null || gzipCompressionExcludedPaths.isEmpty()) {
            return true;
        }
        if (GzipHandlerUtil.isGzipCompressionCompletelyDisabled(gzipCompressionExcludedPaths)) {
            return false;
        }
        IncludeExclude paths = new IncludeExclude(PathSpecSet.class);
        paths.exclude((Object[])gzipCompressionExcludedPaths.toArray(new String[0]));
        return paths.test((Object)endpoint);
    }
}

