/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.oidc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    ConfigUtils() {
    }

    static String getConfigValueAsString(ServiceConfiguration conf, String configProp) throws IllegalArgumentException {
        String value = ConfigUtils.getConfigValueAsStringImpl(conf, configProp);
        log.info("Configuration for [{}] is [{}]", (Object)configProp, (Object)value);
        return value;
    }

    static String getConfigValueAsString(ServiceConfiguration conf, String configProp, String defaultValue) throws IllegalArgumentException {
        String value = ConfigUtils.getConfigValueAsStringImpl(conf, configProp);
        if (value == null) {
            value = defaultValue;
        }
        log.info("Configuration for [{}] is [{}]", (Object)configProp, (Object)value);
        return value;
    }

    static Set<String> getConfigValueAsSet(ServiceConfiguration conf, String configProp) {
        String value = ConfigUtils.getConfigValueAsStringImpl(conf, configProp);
        if (StringUtils.isBlank((CharSequence)value)) {
            log.info("Configuration for [{}] is the empty set.", (Object)configProp);
            return Collections.emptySet();
        }
        Set<String> set = Arrays.stream(value.trim().split("\\s*,\\s*")).collect(Collectors.toSet());
        log.info("Configuration for [{}] is [{}].", (Object)configProp, (Object)String.join((CharSequence)", ", set));
        return set;
    }

    private static String getConfigValueAsStringImpl(ServiceConfiguration conf, String configProp) throws IllegalArgumentException {
        Object value = conf.getProperty(configProp);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    static int getConfigValueAsInt(ServiceConfiguration conf, String configProp, int defaultValue) {
        Object value = conf.getProperty(configProp);
        if (value instanceof Integer) {
            log.info("Configuration for [{}] is [{}]", (Object)configProp, value);
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Expected configuration for [{}] to be a long, but got [{}]. Using default value: [{}]", new Object[]{configProp, value, defaultValue, numberFormatException});
                return defaultValue;
            }
        }
        log.info("Configuration for [{}] is using the default value: [{}]", (Object)configProp, (Object)defaultValue);
        return defaultValue;
    }

    static boolean getConfigValueAsBoolean(ServiceConfiguration conf, String configProp, boolean defaultValue) {
        Object value = conf.getProperty(configProp);
        if (value instanceof Boolean) {
            log.info("Configuration for [{}] is [{}]", (Object)configProp, value);
            return (Boolean)value;
        }
        if (value instanceof String) {
            boolean result = Boolean.parseBoolean((String)value);
            log.info("Configuration for [{}] is [{}]", (Object)configProp, (Object)result);
            return result;
        }
        log.info("Configuration for [{}] is using the default value: [{}]", (Object)configProp, (Object)defaultValue);
        return defaultValue;
    }
}

