/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.auth;

import io.oxia.client.api.Authentication;
import io.oxia.client.api.EncodedAuthenticationParameterSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class TokenAuthentication
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final String AUTHORIZATION_KEY = "Authorization";
    private static final String BEARER_TYPE = "Bearer";
    private Supplier<String> tokenSupplier;

    private TokenAuthentication() {
    }

    public TokenAuthentication(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public TokenAuthentication(String token) {
        this(() -> token);
    }

    public Map<String, String> generateCredentials() {
        return Collections.singletonMap(AUTHORIZATION_KEY, String.format("%s %s", BEARER_TYPE, this.tokenSupplier.get()));
    }

    public void configure(String encodedAuthParamString) {
        if (encodedAuthParamString.startsWith("token:")) {
            this.tokenSupplier = new TokenSupplier(encodedAuthParamString.substring("token:".length()));
        } else if (encodedAuthParamString.startsWith("file:")) {
            URI filePath = URI.create(encodedAuthParamString);
            this.tokenSupplier = new URITokenSupplier(filePath);
        } else {
            throw new IllegalArgumentException("Invalid token configuration: " + encodedAuthParamString);
        }
    }

    private record TokenSupplier(String token) implements Supplier<String>
    {
        @Override
        public String get() {
            return this.token;
        }
    }

    private record URITokenSupplier(URI uri) implements Supplier<String>
    {
        @Override
        public String get() {
            try {
                return Files.readString(Paths.get(this.uri)).trim();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read token from file", e);
            }
        }
    }
}

