/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.util;

import io.grpc.internal.BackoffPolicy;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public final class Backoff
implements BackoffPolicy {
    private final long initialDelayMillis;
    private long nextDelayMillis;
    private final long maxDelayMillis;
    public static final long DEFAULT_INITIAL_DELAY_MILLIS = 100L;
    public static final long DEFAULT_MAX_DELAY_SECONDS = 60L;

    public Backoff() {
        this(100L, TimeUnit.MILLISECONDS, 60L, TimeUnit.SECONDS);
    }

    public Backoff(long initialDelay, TimeUnit unitInitialDelay, long maxDelay, TimeUnit unitMaxDelay) {
        this.initialDelayMillis = unitInitialDelay.toMillis(initialDelay);
        this.maxDelayMillis = unitMaxDelay.toMillis(maxDelay);
        this.nextDelayMillis = this.initialDelayMillis;
    }

    public long nextDelayMillis() {
        long currentDelayMillis = this.nextDelayMillis;
        if (currentDelayMillis < this.maxDelayMillis) {
            this.nextDelayMillis = Math.min(this.nextDelayMillis * 2L, this.maxDelayMillis);
        }
        return ThreadLocalRandom.current().nextLong(currentDelayMillis, (long)((double)currentDelayMillis * 1.2));
    }

    public void reset() {
        this.nextDelayMillis = this.initialDelayMillis;
    }

    public long nextBackoffNanos() {
        return TimeUnit.MILLISECONDS.toNanos(this.nextDelayMillis());
    }
}

