/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;

public interface ModularLoadManagerStrategy {
    public Optional<String> selectBroker(Set<String> var1, BundleData var2, LoadData var3, ServiceConfiguration var4);

    default public void onActiveBrokersChange(Set<String> activeBrokers) {
    }

    public static ModularLoadManagerStrategy create(ServiceConfiguration conf) {
        try {
            return (ModularLoadManagerStrategy)Reflections.createInstance((String)conf.getLoadBalancerLoadPlacementStrategy(), ModularLoadManagerStrategy.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load LoadBalancerLoadPlacementStrategy:" + conf.getLoadBalancerLoadPlacementStrategy(), e);
        }
    }
}

