/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannel;
import org.apache.pulsar.broker.loadbalance.extensions.manager.SplitManager;
import org.apache.pulsar.broker.loadbalance.extensions.models.Split;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitDecision;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.LoadManagerScheduler;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.DefaultNamespaceBundleSplitStrategyImpl;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.NamespaceBundleSplitStrategy;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitScheduler
implements LoadManagerScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitScheduler.class);
    private final PulsarService pulsar;
    private final ScheduledExecutorService loadManagerExecutor;
    private final LoadManagerContext context;
    private final ServiceConfiguration conf;
    private final ServiceUnitStateChannel serviceUnitStateChannel;
    private final NamespaceBundleSplitStrategy bundleSplitStrategy;
    private final SplitCounter counter;
    private final SplitManager splitManager;
    private final AtomicReference<List<Metrics>> splitMetrics;
    private volatile ScheduledFuture<?> task;
    private long counterLastUpdatedAt = 0L;

    public SplitScheduler(PulsarService pulsar, ServiceUnitStateChannel serviceUnitStateChannel, SplitManager splitManager, SplitCounter counter, AtomicReference<List<Metrics>> splitMetrics, LoadManagerContext context, NamespaceBundleSplitStrategy bundleSplitStrategy) {
        this.pulsar = pulsar;
        this.loadManagerExecutor = pulsar.getLoadManagerExecutor();
        this.splitManager = splitManager;
        this.counter = counter;
        this.splitMetrics = splitMetrics;
        this.context = context;
        this.conf = pulsar.getConfiguration();
        this.bundleSplitStrategy = bundleSplitStrategy;
        this.serviceUnitStateChannel = serviceUnitStateChannel;
    }

    public SplitScheduler(PulsarService pulsar, ServiceUnitStateChannel serviceUnitStateChannel, SplitManager splitManager, SplitCounter counter, AtomicReference<List<Metrics>> splitMetrics, LoadManagerContext context) {
        this(pulsar, serviceUnitStateChannel, splitManager, counter, splitMetrics, context, new DefaultNamespaceBundleSplitStrategyImpl(counter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean debugMode = ExtensibleLoadManagerImpl.debug(this.conf, log);
        if (debugMode) {
            log.info("Load balancer enabled: {}, Split enabled: {}.", (Object)this.conf.isLoadBalancerEnabled(), (Object)this.conf.isLoadBalancerAutoBundleSplitEnabled());
        }
        if (!this.isLoadBalancerAutoBundleSplitEnabled()) {
            if (debugMode) {
                log.info("The load balancer or load balancer split already disabled. Skipping.");
            }
            return;
        }
        NamespaceBundleSplitStrategy namespaceBundleSplitStrategy = this.bundleSplitStrategy;
        synchronized (namespaceBundleSplitStrategy) {
            Set<SplitDecision> decisions = this.bundleSplitStrategy.findBundlesToSplit(this.context, this.pulsar);
            if (debugMode) {
                log.info("Split Decisions:", decisions);
            }
            if (!decisions.isEmpty()) {
                long asyncOpTimeoutMs = this.conf.getNamespaceBundleUnloadingTimeoutMs();
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (SplitDecision decision : decisions) {
                    if (decision.getLabel() != SplitDecision.Label.Success) continue;
                    Split split = decision.getSplit();
                    futures.add(this.splitManager.waitAsync(this.serviceUnitStateChannel.publishSplitEventAsync(split), split.serviceUnit(), decision, asyncOpTimeoutMs, TimeUnit.MILLISECONDS));
                }
                try {
                    FutureUtil.waitForAll(futures).get(asyncOpTimeoutMs, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e) {
                    log.error("Failed to wait for split events to persist.", e);
                }
            } else if (debugMode) {
                log.info("BundleSplitStrategy returned no bundles to split.");
            }
        }
        if (this.counter.updatedAt() > this.counterLastUpdatedAt) {
            this.splitMetrics.set(this.counter.toMetrics(this.pulsar.getAdvertisedAddress()));
            this.counterLastUpdatedAt = this.counter.updatedAt();
        }
    }

    @Override
    public void start() {
        long interval = TimeUnit.MINUTES.toMillis(this.conf.getLoadBalancerSplitIntervalMinutes());
        this.task = this.loadManagerExecutor.scheduleAtFixedRate(() -> {
            try {
                this.execute();
                boolean debugMode = ExtensibleLoadManagerImpl.debug(this.conf, log);
                if (debugMode) {
                    StringJoiner joiner = new StringJoiner("\n");
                    joiner.add("### OwnershipEntrySet start ###");
                    this.serviceUnitStateChannel.getOwnershipEntrySet().forEach(e -> joiner.add(e.toString()));
                    joiner.add("### OwnershipEntrySet end ###");
                    log.info(joiner.toString());
                }
            }
            catch (Throwable e2) {
                log.error("Failed to run the split job.", e2);
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    private boolean isLoadBalancerAutoBundleSplitEnabled() {
        return this.conf.isLoadBalancerEnabled() && this.conf.isLoadBalancerAutoBundleSplitEnabled();
    }
}

