/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.impl.cache.PooledByteBufAllocatorStats;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class ManagedLedgerCacheMetrics
extends AbstractMetrics {
    private List<Metrics> metrics = new ArrayList<Metrics>();

    public ManagedLedgerCacheMetrics(PulsarService pulsar) {
        super(pulsar);
    }

    @Override
    public synchronized List<Metrics> generate() {
        ManagedLedgerFactoryMXBean mlCacheStats = this.getManagedLedgerCacheStats();
        Metrics m = this.createMetrics();
        m.put("brk_ml_count", (Object)mlCacheStats.getNumberOfManagedLedgers());
        m.put("brk_ml_cache_used_size", (Object)mlCacheStats.getCacheUsedSize());
        m.put("brk_ml_cache_inserted_entries_total", (Object)mlCacheStats.getCacheInsertedEntriesCount());
        m.put("brk_ml_cache_evicted_entries_total", (Object)mlCacheStats.getCacheEvictedEntriesCount());
        m.put("brk_ml_cache_entries", (Object)mlCacheStats.getCacheEntriesCount());
        m.put("brk_ml_cache_evictions", (Object)mlCacheStats.getNumberOfCacheEvictions());
        m.put("brk_ml_cache_hits_rate", (Object)mlCacheStats.getCacheHitsRate());
        m.put("brk_ml_cache_misses_rate", (Object)mlCacheStats.getCacheMissesRate());
        m.put("brk_ml_cache_hits_throughput", (Object)mlCacheStats.getCacheHitsThroughput());
        m.put("brk_ml_cache_misses_throughput", (Object)mlCacheStats.getCacheMissesThroughput());
        PooledByteBufAllocatorStats allocatorStats = new PooledByteBufAllocatorStats(RangeEntryCacheImpl.ALLOCATOR);
        m.put("brk_ml_cache_pool_allocated", (Object)allocatorStats.totalAllocated);
        m.put("brk_ml_cache_pool_used", (Object)allocatorStats.totalUsed);
        m.put("brk_ml_cache_pool_active_allocations", (Object)allocatorStats.activeAllocations);
        m.put("brk_ml_cache_pool_active_allocations_small", (Object)allocatorStats.activeAllocationsSmall);
        m.put("brk_ml_cache_pool_active_allocations_normal", (Object)allocatorStats.activeAllocationsNormal);
        m.put("brk_ml_cache_pool_active_allocations_huge", (Object)allocatorStats.activeAllocationsHuge);
        this.metrics.clear();
        this.metrics.add(m);
        return this.metrics;
    }
}

