/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandleAttributes;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandleStats;
import org.apache.pulsar.common.naming.TopicName;

public class PendingAckHandleStatsImpl
implements PendingAckHandleStats {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static Counter commitTxnCounter;
    private static Counter abortTxnCounter;
    private static Summary commitTxnLatency;
    private static boolean exposeTopicLevelMetrics0;
    private final String[] labelSucceed;
    private final String[] labelFailed;
    private final String[] commitLatencyLabel;
    private final String topic;
    private final String subscription;
    private final LongAdder commitTxnSucceedCounter = new LongAdder();
    private final LongAdder commitTxnFailedCounter = new LongAdder();
    private final LongAdder abortTxnSucceedCounter = new LongAdder();
    private final LongAdder abortTxnFailedCounter = new LongAdder();
    private volatile PendingAckHandleAttributes attributes = null;
    private static final AtomicReferenceFieldUpdater<PendingAckHandleStatsImpl, PendingAckHandleAttributes> ATTRIBUTES_UPDATER;

    public PendingAckHandleStatsImpl(String topic, String subscription, boolean exposeTopicLevelMetrics) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String namespace;
        PendingAckHandleStatsImpl.initialize(exposeTopicLevelMetrics);
        if (StringUtils.isBlank((CharSequence)topic)) {
            topic = "unknown";
            namespace = "unknown";
        } else {
            try {
                namespace = TopicName.get((String)topic).getNamespace();
            }
            catch (IllegalArgumentException ex) {
                namespace = "unknown";
            }
        }
        this.topic = topic;
        this.subscription = subscription;
        if (exposeTopicLevelMetrics0) {
            String[] stringArray4 = new String[4];
            stringArray4[0] = namespace;
            stringArray4[1] = topic;
            stringArray4[2] = subscription;
            stringArray3 = stringArray4;
            stringArray4[3] = "succeed";
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = namespace;
            stringArray3 = stringArray5;
            stringArray5[1] = "succeed";
        }
        this.labelSucceed = stringArray3;
        if (exposeTopicLevelMetrics0) {
            String[] stringArray6 = new String[4];
            stringArray6[0] = namespace;
            stringArray6[1] = topic;
            stringArray6[2] = subscription;
            stringArray2 = stringArray6;
            stringArray6[3] = "failed";
        } else {
            String[] stringArray7 = new String[2];
            stringArray7[0] = namespace;
            stringArray2 = stringArray7;
            stringArray7[1] = "failed";
        }
        this.labelFailed = stringArray2;
        if (exposeTopicLevelMetrics0) {
            String[] stringArray8 = new String[3];
            stringArray8[0] = namespace;
            stringArray8[1] = topic;
            stringArray = stringArray8;
            stringArray8[2] = subscription;
        } else {
            String[] stringArray9 = new String[1];
            stringArray = stringArray9;
            stringArray9[0] = namespace;
        }
        this.commitLatencyLabel = stringArray;
    }

    @Override
    public void recordCommitTxn(boolean success, long nanos) {
        LongAdder counter;
        String[] labels;
        if (success) {
            labels = this.labelSucceed;
            counter = this.commitTxnSucceedCounter;
            ((Summary.Child)commitTxnLatency.labels(this.commitLatencyLabel)).observe((double)TimeUnit.NANOSECONDS.toMicros(nanos));
        } else {
            labels = this.labelFailed;
            counter = this.commitTxnFailedCounter;
        }
        ((Counter.Child)commitTxnCounter.labels(labels)).inc();
        counter.increment();
    }

    @Override
    public void recordAbortTxn(boolean success) {
        ((Counter.Child)abortTxnCounter.labels(success ? this.labelSucceed : this.labelFailed)).inc();
        LongAdder counter = success ? this.abortTxnSucceedCounter : this.abortTxnFailedCounter;
        counter.increment();
    }

    @Override
    public void close() {
        if (exposeTopicLevelMetrics0) {
            commitTxnCounter.remove(this.labelSucceed);
            commitTxnCounter.remove(this.labelFailed);
            abortTxnCounter.remove(this.labelSucceed);
            abortTxnCounter.remove(this.labelFailed);
        }
    }

    @Override
    public long getCommitSuccessCount() {
        return this.commitTxnSucceedCounter.sum();
    }

    @Override
    public long getCommitFailedCount() {
        return this.commitTxnFailedCounter.sum();
    }

    @Override
    public long getAbortSuccessCount() {
        return this.abortTxnSucceedCounter.sum();
    }

    @Override
    public long getAbortFailedCount() {
        return this.abortTxnFailedCounter.sum();
    }

    @Override
    public PendingAckHandleAttributes getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        return ATTRIBUTES_UPDATER.updateAndGet(this, old -> old != null ? old : new PendingAckHandleAttributes(this.topic, this.subscription));
    }

    static void initialize(boolean exposeTopicLevelMetrics) {
        if (INITIALIZED.compareAndSet(false, true)) {
            String[] stringArray;
            String[] stringArray2;
            exposeTopicLevelMetrics0 = exposeTopicLevelMetrics;
            if (exposeTopicLevelMetrics) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "namespace";
                stringArray3[1] = "topic";
                stringArray3[2] = "subscription";
                stringArray2 = stringArray3;
                stringArray3[3] = "status";
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "namespace";
                stringArray2 = stringArray4;
                stringArray4[1] = "status";
            }
            String[] labelNames = stringArray2;
            commitTxnCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_txn_tp_committed_count", (String)"-").labelNames(labelNames)).register();
            abortTxnCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_txn_tp_aborted_count", (String)"-").labelNames(labelNames)).register();
            Summary.Builder builder = Summary.build((String)"pulsar_txn_tp_commit_latency", (String)"-").quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).quantile(0.999, 0.01);
            if (exposeTopicLevelMetrics) {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "namespace";
                stringArray5[1] = "topic";
                stringArray = stringArray5;
                stringArray5[2] = "subscription";
            } else {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "namespace";
            }
            commitTxnLatency = (Summary)((Summary.Builder)builder.labelNames(stringArray)).register();
        }
    }

    static {
        ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PendingAckHandleStatsImpl.class, PendingAckHandleAttributes.class, "attributes");
    }
}

