/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;

public class ManagedCursorMXBeanImpl
implements ManagedCursorMXBean {
    private final LongAdder persistLedgeSucceed = new LongAdder();
    private final LongAdder persistLedgeFailed = new LongAdder();
    private final LongAdder persistZookeeperSucceed = new LongAdder();
    private final LongAdder persistZookeeperFailed = new LongAdder();
    private final LongAdder writeCursorLedgerSize = new LongAdder();
    private final LongAdder writeCursorLedgerLogicalSize = new LongAdder();
    private final LongAdder readCursorLedgerSize = new LongAdder();
    private final ManagedCursor managedCursor;

    public ManagedCursorMXBeanImpl(ManagedCursor managedCursor) {
        this.managedCursor = managedCursor;
    }

    @Override
    public String getName() {
        return this.managedCursor.getName();
    }

    @Override
    public String getLedgerName() {
        return this.managedCursor.getManagedLedger().getName();
    }

    @Override
    public void persistToLedger(boolean success) {
        if (success) {
            this.persistLedgeSucceed.increment();
        } else {
            this.persistLedgeFailed.increment();
        }
    }

    @Override
    public void persistToZookeeper(boolean success) {
        if (success) {
            this.persistZookeeperSucceed.increment();
        } else {
            this.persistZookeeperFailed.increment();
        }
    }

    @Override
    public long getPersistLedgerSucceed() {
        return this.persistLedgeSucceed.longValue();
    }

    @Override
    public long getPersistLedgerErrors() {
        return this.persistLedgeFailed.longValue();
    }

    @Override
    public long getPersistZookeeperSucceed() {
        return this.persistZookeeperSucceed.longValue();
    }

    @Override
    public long getPersistZookeeperErrors() {
        return this.persistZookeeperFailed.longValue();
    }

    @Override
    public void addWriteCursorLedgerSize(long size) {
        this.writeCursorLedgerSize.add(size * (long)this.managedCursor.getManagedLedger().getConfig().getWriteQuorumSize());
        this.writeCursorLedgerLogicalSize.add(size);
    }

    @Override
    public void addReadCursorLedgerSize(long size) {
        this.readCursorLedgerSize.add(size);
    }

    @Override
    public long getWriteCursorLedgerSize() {
        return this.writeCursorLedgerSize.longValue();
    }

    @Override
    public long getWriteCursorLedgerLogicalSize() {
        return this.writeCursorLedgerLogicalSize.longValue();
    }

    @Override
    public long getReadCursorLedgerSize() {
        return this.readCursorLedgerSize.longValue();
    }
}

