/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.cpu;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class ContextSwitchRateHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME = "process.runtime.jvm.cpu.context_switch";
    private static final String EVENT_NAME = "jdk.ThreadContextSwitchRate";
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile double value = 0.0;

    public ContextSwitchRateHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME).ofDoubles().setUnit("Hz").buildWithCallback(codm -> codm.record(this.value)));
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.value = ev.getDouble("switchRate");
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.CONTEXT_SWITCH_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

