/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.cpu;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class OverallCpuLoadHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME_PROCESS = "process.runtime.jvm.cpu.utilization";
    private static final String METRIC_NAME_MACHINE = "process.runtime.jvm.system.cpu.utilization";
    private static final String METRIC_DESCRIPTION_PROCESS = "Recent CPU utilization for the process";
    private static final String METRIC_DESCRIPTION_MACHINE = "Recent CPU utilization for the whole system";
    private static final String EVENT_NAME = "jdk.CPULoad";
    private static final String JVM_USER = "jvmUser";
    private static final String JVM_SYSTEM = "jvmSystem";
    private static final String MACHINE_TOTAL = "machineTotal";
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile double process = 0.0;
    private volatile double machine = 0.0;

    public OverallCpuLoadHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.gaugeBuilder(METRIC_NAME_PROCESS).setDescription(METRIC_DESCRIPTION_PROCESS).setUnit("1").buildWithCallback(measurement -> measurement.record(this.process)));
        this.observables.add((AutoCloseable)meter.gaugeBuilder(METRIC_NAME_MACHINE).setDescription(METRIC_DESCRIPTION_MACHINE).setUnit("1").buildWithCallback(measurement -> measurement.record(this.machine)));
    }

    @Override
    public void accept(RecordedEvent ev) {
        if (ev.hasField(JVM_USER) && ev.hasField(JVM_SYSTEM)) {
            this.process = ev.getDouble(JVM_USER) + ev.getDouble(JVM_SYSTEM);
        }
        if (ev.hasField(MACHINE_TOTAL)) {
            this.machine = ev.getDouble(MACHINE_TOTAL);
        }
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.CPU_UTILIZATION_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

