/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.garbagecollection;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class YoungGarbageCollectionHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.YoungGarbageCollection";
    private final LongHistogram histogram;
    private final Attributes attributes;

    public YoungGarbageCollectionHandler(Meter meter, String gc) {
        this.histogram = meter.histogramBuilder("process.runtime.jvm.gc.duration").setDescription("Duration of JVM garbage collection actions").setUnit("ms").ofLongs().build();
        this.attributes = Attributes.of(Constants.ATTR_GC, (Object)gc, Constants.ATTR_ACTION, (Object)"end of minor GC");
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.histogram.record(ev.getLong("duration"), this.attributes);
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.GC_DURATION_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }
}

