/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public class ClusterManagerLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public ClusterManagerLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    ClusterManagerLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cluster_manager_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        LinkedHashMap<String, Object> parsedChildPolicies = new LinkedHashMap<String, Object>();
        try {
            Map childPolicies = JsonUtil.getObject(rawConfig, (String)"childPolicy");
            if (childPolicies == null || childPolicies.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No child policy provided for cluster_manager LB policy: " + rawConfig));
            }
            for (String name : childPolicies.keySet()) {
                Map childPolicy = JsonUtil.getObject((Map)childPolicies, (String)name);
                if (childPolicy == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No config for child " + name + " in cluster_manager LB policy: " + rawConfig));
                }
                LoadBalancerRegistry registry = this.lbRegistry != null ? this.lbRegistry : LoadBalancerRegistry.getDefaultRegistry();
                NameResolver.ConfigOrError childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig((List)JsonUtil.getListOfObjects((Map)childPolicy, (String)"lbPolicy"), (LoadBalancerRegistry)registry);
                if (childConfig.getError() != null) {
                    Status error = childConfig.getError();
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withCause(error.getCause()).withDescription(error.getDescription()).augmentDescription("Failed to parse config for child " + name));
                }
                parsedChildPolicies.put(name, childConfig.getConfig());
            }
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withCause((Throwable)e).withDescription("Failed to parse cluster_manager LB config: " + rawConfig));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new ClusterManagerConfig(parsedChildPolicies));
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterManagerLoadBalancer(helper);
    }

    static class ClusterManagerConfig {
        final Map<String, Object> childPolicies;

        ClusterManagerConfig(Map<String, Object> childPolicies) {
            this.childPolicies = Collections.unmodifiableMap(childPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusterManagerConfig)) {
                return false;
            }
            ClusterManagerConfig config = (ClusterManagerConfig)o;
            return Objects.equals(this.childPolicies, config.childPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.childPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("childPolicies", this.childPolicies).toString();
        }
    }
}

