# PIP-375: Expose the Admin client configs: readTimeout, requestTimeout, connectionTimeout

# Background knowledge

- `pulsar-admin sinks create` will upload files to brokers, but if the file is large and the network is slow, it may cost a long time.
- The default value of `requestTimeout` of Admin API is `60s`, after the fix https://github.com/apache/pulsar/pull/23128, it was changed to `300s`.

# Motivation

We'd better to expose the following configs to users:

```properties
# The value is the timeout to build a connection to the server. Value 0 represents infinity. Negative values are not allowed.
connectionTimeout

# The value is the timeout to read a response. If the server doesn't respond within the defined timeframe, ProcessingException is thrown with TimeoutException as a cause.
Value 0 represents infinity. Negative values are not allowed.
readTimeout

# Request time out in seconds for the pulsar admin client for any request, it includes building connections, sending requests, and reading responses.
requestTimeout
```

# Goals

Expose the Admin client configs: `readTimeout`, `requestTimeout` and `connectionTimeout` to users.

# Detailed Design

### Configuration

**broker.conf**
```properties
# The value is used for the brokers' internal pulsar admin client, which means the timeout to read a response. If the server doesn't respond within the defined timeframe, ProcessingException is thrown with TimeoutException as a cause.
Value 0 represents infinity. Negative values are not allowed.
brokerAdminReadTimeoutInSeconds=60
# The value is used for the brokers' internal pulsar admin client, which means request time out in seconds for the pulsar admin client for any request, it includes building connections, sending requests, and reading responses.
brokerAdminRequestTimeoutInSeconds=300
# The value is used for the brokers' internal pulsar admin client, which means the timeout to build a connection to the server. Value 0 represents infinity. Negative values are not allowed.
brokerAdminConnectionTimeoutInSeconds=10
```

### CLI

**client.conf**
```properties
# The value is used for the pulsar admin client, which means the timeout to read a response. If the server doesn't respond within the defined timeframe, ProcessingException is thrown with TimeoutException as a cause.
Value 0 represents infinity. Negative values are not allowed.
adminReadTimeoutInSeconds=60
# The value is used for the pulsar admin client, which means request time out in seconds for the pulsar admin client for any request, it includes building connections, sending requests, and reading responses.
adminRequestTimeoutInSeconds=300
# The value is used for the pulsar admin client, which means the timeout to build a connection to the server. Value 0 represents infinity. Negative values are not allowed.
adminConnectionTimeoutInSeconds=10
```

# Links
* Mailing List discussion thread: https://lists.apache.org/thread/nwvc1jc29k0hnvtn6qtpdyb8b5xp3ch7
* Mailing List voting thread: https://lists.apache.org/thread/2bmzvv7hyfnb2kf6jsgmgjtrjz23qhj2
