/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface Authentication
extends Closeable,
Serializable {
    public String getAuthMethodName();

    @Deprecated
    default public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        throw new PulsarClientException.UnsupportedAuthenticationException("Method not implemented!");
    }

    default public AuthenticationDataProvider getAuthData(String brokerHostName) throws PulsarClientException {
        return this.getAuthData();
    }

    @Deprecated
    public void configure(Map<String, String> var1);

    public void start() throws PulsarClientException;

    default public void authenticationStage(String requestUrl, AuthenticationDataProvider authData, Map<String, String> previousResHeaders, CompletableFuture<Map<String, String>> authFuture) {
        authFuture.complete(null);
    }

    default public Set<Map.Entry<String, String>> newRequestHeader(String hostName, AuthenticationDataProvider authData, Map<String, String> previousResHeaders) throws Exception {
        return authData.getHttpHeaders();
    }
}

