/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import java.net.URI;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.metadata.LogMetadata;
import org.junit.Assert;
import org.junit.Test;

public class TestLogMetadata {
    @Test(timeout=60000L)
    public void testGetPaths() throws Exception {
        String rootPath = "/test-get-paths";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        String logRootPath = uri.getPath() + "/" + logName + "/" + logIdentifier;
        String logSegmentName = "test-segment";
        LogMetadata logMetadata = new LogMetadata(uri, logName, logIdentifier);
        Assert.assertEquals((String)"wrong log name", (Object)logName, (Object)logMetadata.getLogName());
        Assert.assertEquals((String)"wrong root path", (Object)logRootPath, (Object)logMetadata.getLogRootPath());
        Assert.assertEquals((String)"wrong log segments path", (Object)(logRootPath + "/ledgers"), (Object)logMetadata.getLogSegmentsPath());
        Assert.assertEquals((String)"wrong log segment path", (Object)(logRootPath + "/ledgers" + "/" + logSegmentName), (Object)logMetadata.getLogSegmentPath(logSegmentName));
        Assert.assertEquals((String)"wrong lock path", (Object)(logRootPath + "/lock"), (Object)logMetadata.getLockPath());
        Assert.assertEquals((String)"wrong max tx id path", (Object)(logRootPath + "/maxtxid"), (Object)logMetadata.getMaxTxIdPath());
        Assert.assertEquals((String)"wrong allocation path", (Object)(logRootPath + "/allocation"), (Object)logMetadata.getAllocationPath());
        Assert.assertEquals((String)"wrong qualified name", (Object)(logName + ":" + logIdentifier), (Object)logMetadata.getFullyQualifiedName());
    }
}

