/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import io.oxia.client.GetResultIterator;
import io.oxia.client.api.AsyncOxiaClient;
import io.oxia.client.api.GetResult;
import io.oxia.client.api.Notification;
import io.oxia.client.api.PutResult;
import io.oxia.client.api.RangeScanConsumer;
import io.oxia.client.api.SyncOxiaClient;
import io.oxia.client.api.exceptions.UnexpectedVersionIdException;
import io.oxia.client.api.options.DeleteOption;
import io.oxia.client.api.options.DeleteRangeOption;
import io.oxia.client.api.options.GetOption;
import io.oxia.client.api.options.GetSequenceUpdatesOption;
import io.oxia.client.api.options.ListOption;
import io.oxia.client.api.options.PutOption;
import io.oxia.client.api.options.RangeScanOption;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

class SyncOxiaClientImpl
implements SyncOxiaClient {
    private final AsyncOxiaClient asyncClient;

    public PutResult put(@NonNull String key, byte @NonNull [] value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public PutResult put(@NonNull String key, byte @NonNull [] value, @NonNull Set<PutOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (PutResult)this.asyncClient.put(key, value, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public boolean delete(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.delete(key, Collections.emptySet());
    }

    public boolean delete(@NonNull String key, @NonNull Set<DeleteOption> options) throws UnexpectedVersionIdException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (Boolean)this.asyncClient.delete(key, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void deleteRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        this.deleteRange(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    public void deleteRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, @NonNull Set<DeleteRangeOption> options) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            this.asyncClient.deleteRange(startKeyInclusive, endKeyExclusive, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public GetResult get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.get(key, Collections.emptySet());
    }

    public GetResult get(@NonNull String key, @NonNull Set<GetOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (GetResult)this.asyncClient.get(key, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @NonNull
    public List<String> list(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return this.list(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    @NonNull
    public List<String> list(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, @NonNull Set<ListOption> options) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try {
            return (List)this.asyncClient.list(startKeyInclusive, endKeyExclusive, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.asyncClient.notifications(notificationCallback);
    }

    public Closeable getSequenceUpdates(@NonNull String key, @NonNull Consumer<String> listener, @NonNull Set<GetSequenceUpdatesOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.asyncClient.getSequenceUpdates(key, listener, options);
    }

    public Iterable<GetResult> rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return this.rangeScan(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    public Iterable<GetResult> rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, Set<RangeScanOption> options) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return () -> {
            GetResultIterator gri = new GetResultIterator();
            this.asyncClient.rangeScan(startKeyInclusive, endKeyExclusive, (RangeScanConsumer)gri, options);
            return gri;
        };
    }

    public void close() throws Exception {
        this.asyncClient.close();
    }

    @Generated
    SyncOxiaClientImpl(AsyncOxiaClient asyncClient) {
        this.asyncClient = asyncClient;
    }
}

