/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetrics;
import io.opentelemetry.instrumentation.runtimemetrics.java8.BufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalBufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalCpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalMemoryPools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;

public final class RuntimeMetricsBuilder {
    private final OpenTelemetry openTelemetry;
    final EnumMap<JfrFeature, Boolean> enabledFeatureMap;
    private boolean disableJmx = false;
    private boolean enableExperimentalJmxTelemetry = false;

    RuntimeMetricsBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.enabledFeatureMap = new EnumMap(JfrFeature.class);
        for (JfrFeature feature : JfrFeature.values()) {
            this.enabledFeatureMap.put(feature, feature.isDefaultEnabled());
        }
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder enableAllFeatures() {
        Arrays.stream(JfrFeature.values()).forEach(this::enableFeature);
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder enableFeature(JfrFeature feature) {
        this.enabledFeatureMap.put(feature, true);
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder disableAllFeatures() {
        Arrays.stream(JfrFeature.values()).forEach(this::disableFeature);
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder disableAllMetrics() {
        this.disableAllFeatures();
        this.disableAllJmx();
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder disableFeature(JfrFeature feature) {
        this.enabledFeatureMap.put(feature, false);
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder disableAllJmx() {
        this.disableJmx = true;
        return this;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder enableExperimentalJmxTelemetry() {
        this.enableExperimentalJmxTelemetry = true;
        return this;
    }

    public RuntimeMetrics build() {
        List<AutoCloseable> observables = this.buildObservables();
        RuntimeMetrics.JfrRuntimeMetrics jfrRuntimeMetrics = this.buildJfrMetrics();
        return new RuntimeMetrics(this.openTelemetry, observables, jfrRuntimeMetrics);
    }

    private List<AutoCloseable> buildObservables() {
        if (this.disableJmx) {
            return Collections.emptyList();
        }
        try {
            ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
            observables.addAll(BufferPools.registerObservers((OpenTelemetry)this.openTelemetry));
            observables.addAll(Classes.registerObservers((OpenTelemetry)this.openTelemetry));
            observables.addAll(Cpu.registerObservers((OpenTelemetry)this.openTelemetry));
            observables.addAll(GarbageCollector.registerObservers((OpenTelemetry)this.openTelemetry));
            observables.addAll(MemoryPools.registerObservers((OpenTelemetry)this.openTelemetry));
            observables.addAll(Threads.registerObservers((OpenTelemetry)this.openTelemetry));
            if (this.enableExperimentalJmxTelemetry) {
                observables.addAll(ExperimentalBufferPools.registerObservers((OpenTelemetry)this.openTelemetry));
                observables.addAll(ExperimentalCpu.registerObservers((OpenTelemetry)this.openTelemetry));
                observables.addAll(ExperimentalMemoryPools.registerObservers((OpenTelemetry)this.openTelemetry));
            }
            return observables;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error building RuntimeMetrics", e);
        }
    }

    @Nullable
    private RuntimeMetrics.JfrRuntimeMetrics buildJfrMetrics() {
        if (this.enabledFeatureMap.values().stream().noneMatch(isEnabled -> isEnabled)) {
            return null;
        }
        return RuntimeMetrics.JfrRuntimeMetrics.build(this.openTelemetry, this.enabledFeatureMap::get);
    }
}

