/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.EnumSet;

public enum WriteFlag {
    DEFERRED_SYNC(1);

    public static final EnumSet<WriteFlag> NONE;
    private static final EnumSet<WriteFlag> ONLY_DEFERRED_SYNC;
    private final int value;

    private WriteFlag(int value) {
        this.value = value;
    }

    public static EnumSet<WriteFlag> getWriteFlags(int flagValue) {
        if ((flagValue & WriteFlag.DEFERRED_SYNC.value) == WriteFlag.DEFERRED_SYNC.value) {
            return ONLY_DEFERRED_SYNC;
        }
        return NONE;
    }

    public static int getWriteFlagsValue(EnumSet<WriteFlag> flags) {
        int result = 0;
        for (WriteFlag flag : flags) {
            result |= flag.value;
        }
        return result;
    }

    public int getValue() {
        return this.value;
    }

    static {
        NONE = EnumSet.noneOf(WriteFlag.class);
        ONLY_DEFERRED_SYNC = EnumSet.of(DEFERRED_SYNC);
    }
}

