/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.IntConsumer;
import io.netty.util.NettyRuntime;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.ConcurrentSkipListIntObjMultimap;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.concurrent.MpscAtomicIntegerArrayQueue;
import io.netty.util.concurrent.MpscIntQueue;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReferenceCountUpdater;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;

@SuppressJava6Requirement(reason="Guarded by version check")
final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator.AdaptiveAllocatorApi {
    private static final int LOW_MEM_THRESHOLD = 0x20000000;
    private static final boolean IS_LOW_MEM = Runtime.getRuntime().maxMemory() <= 0x20000000L;
    private static final boolean DISABLE_THREAD_LOCAL_MAGAZINES_ON_LOW_MEM = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.disableThreadLocalMagazinesOnLowMemory", (boolean)true);
    static final int MIN_CHUNK_SIZE = 131072;
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 1;
    private static final int RETIRE_CAPACITY = 256;
    private static final int MAX_STRIPES = IS_LOW_MEM ? 1 : NettyRuntime.availableProcessors() * 2;
    private static final int BUFS_PER_CHUNK = 8;
    private static final int MAX_CHUNK_SIZE = IS_LOW_MEM ? 0x200000 : 0x800000;
    private static final int MAX_POOLED_BUF_SIZE = MAX_CHUNK_SIZE / 8;
    private static final int CHUNK_REUSE_QUEUE = Math.max(2, SystemPropertyUtil.getInt((String)"io.netty.allocator.chunkReuseQueueCapacity", (int)(NettyRuntime.availableProcessors() * 2)));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty.allocator.magazineBufferQueueCapacity", (int)1024);
    private static final int[] SIZE_CLASSES = new int[]{32, 64, 128, 256, 512, 640, 1024, 1152, 2048, 2304, 4096, 4352, 8192, 8704, 16384, 16896};
    private static final int SIZE_CLASSES_COUNT = SIZE_CLASSES.length;
    private static final byte[] SIZE_INDEXES = new byte[SIZE_CLASSES[SIZE_CLASSES_COUNT - 1] / 32 + 1];
    private final ChunkAllocator chunkAllocator;
    private final ChunkRegistry chunkRegistry;
    private final MagazineGroup[] sizeClassedMagazineGroups;
    private final MagazineGroup largeBufferMagazineGroup;
    private final FastThreadLocal<MagazineGroup[]> threadLocalGroup;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, final boolean useCacheForNonEventLoopThreads) {
        this.chunkAllocator = (ChunkAllocator)ObjectUtil.checkNotNull((Object)chunkAllocator, (String)"chunkAllocator");
        this.chunkRegistry = new ChunkRegistry();
        this.sizeClassedMagazineGroups = AdaptivePoolingAllocator.createMagazineGroupSizeClasses(this, false);
        this.largeBufferMagazineGroup = new MagazineGroup(this, chunkAllocator, new BuddyChunkManagementStrategy(), false);
        boolean disableThreadLocalGroups = IS_LOW_MEM && DISABLE_THREAD_LOCAL_MAGAZINES_ON_LOW_MEM;
        this.threadLocalGroup = disableThreadLocalGroups ? null : new FastThreadLocal<MagazineGroup[]>(){

            protected MagazineGroup[] initialValue() {
                if (useCacheForNonEventLoopThreads || ThreadExecutorMap.currentExecutor() != null) {
                    return AdaptivePoolingAllocator.createMagazineGroupSizeClasses(AdaptivePoolingAllocator.this, true);
                }
                return null;
            }

            protected void onRemoval(MagazineGroup[] groups) throws Exception {
                if (groups != null) {
                    for (MagazineGroup group : groups) {
                        group.free();
                    }
                }
            }
        };
    }

    private static MagazineGroup[] createMagazineGroupSizeClasses(AdaptivePoolingAllocator allocator, boolean isThreadLocal) {
        MagazineGroup[] groups = new MagazineGroup[SIZE_CLASSES.length];
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            int segmentSize = SIZE_CLASSES[i];
            groups[i] = new MagazineGroup(allocator, allocator.chunkAllocator, new SizeClassChunkManagementStrategy(segmentSize), isThreadLocal);
        }
        return groups;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue((int)CHUNK_REUSE_QUEUE);
    }

    @Override
    public ByteBuf allocate(int size, int maxCapacity) {
        return this.allocate(size, maxCapacity, Thread.currentThread(), null);
    }

    private AdaptiveByteBuf allocate(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        AdaptiveByteBuf allocated = null;
        if (size <= MAX_POOLED_BUF_SIZE) {
            MagazineGroup[] magazineGroups;
            int index = AdaptivePoolingAllocator.sizeClassIndexOf(size);
            if (!FastThreadLocalThread.willCleanupFastThreadLocals((Thread)Thread.currentThread()) || IS_LOW_MEM || (magazineGroups = (MagazineGroup[])this.threadLocalGroup.get()) == null) {
                magazineGroups = this.sizeClassedMagazineGroups;
            }
            if (index < magazineGroups.length) {
                allocated = magazineGroups[index].allocate(size, maxCapacity, currentThread, buf);
            } else if (!IS_LOW_MEM) {
                allocated = this.largeBufferMagazineGroup.allocate(size, maxCapacity, currentThread, buf);
            }
        }
        if (allocated == null) {
            allocated = this.allocateFallback(size, maxCapacity, currentThread, buf);
        }
        return allocated;
    }

    private static int sizeIndexOf(int size) {
        return size + 31 >> 5;
    }

    static int sizeClassIndexOf(int size) {
        int sizeIndex = AdaptivePoolingAllocator.sizeIndexOf(size);
        if (sizeIndex < SIZE_INDEXES.length) {
            return SIZE_INDEXES[sizeIndex];
        }
        return SIZE_CLASSES_COUNT;
    }

    static int[] getSizeClasses() {
        return (int[])SIZE_CLASSES.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocateFallback(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        Magazine magazine;
        if (buf != null) {
            Chunk chunk = buf.chunk;
            if (chunk == null || chunk == Magazine.MAGAZINE_FREED || (magazine = chunk.currentMagazine()) == null) {
                magazine = this.getFallbackMagazine(currentThread);
            }
        } else {
            magazine = this.getFallbackMagazine(currentThread);
            buf = magazine.newBuffer();
        }
        AbstractByteBuf innerChunk = this.chunkAllocator.allocate(size, maxCapacity);
        Chunk chunk = new Chunk(innerChunk, magazine);
        this.chunkRegistry.add(chunk);
        try {
            boolean success = chunk.readInitInto(buf, size, size, maxCapacity);
            assert (success) : "Failed to initialize ByteBuf with dedicated chunk";
        }
        finally {
            chunk.release();
        }
        return buf;
    }

    private Magazine getFallbackMagazine(Thread currentThread) {
        Magazine[] mags = this.largeBufferMagazineGroup.magazines;
        return mags[(int)currentThread.getId() & mags.length - 1];
    }

    void reallocate(int size, int maxCapacity, AdaptiveByteBuf into) {
        AdaptiveByteBuf result = this.allocate(size, maxCapacity, Thread.currentThread(), into);
        assert (result == into) : "Re-allocation created separate buffer instance";
    }

    @Override
    public long usedMemory() {
        return this.chunkRegistry.totalCapacity();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    private void free() {
        this.largeBufferMagazineGroup.free();
    }

    static /* synthetic */ Queue access$900() {
        return AdaptivePoolingAllocator.createSharedChunkQueue();
    }

    static {
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
        int lastIndex = 0;
        for (int i = 0; i < SIZE_CLASSES_COUNT; ++i) {
            int sizeClass = SIZE_CLASSES[i];
            assert ((sizeClass & 5) == 0) : "Size class must be a multiple of 32";
            int sizeIndex = AdaptivePoolingAllocator.sizeIndexOf(sizeClass);
            Arrays.fill(SIZE_INDEXES, lastIndex + 1, sizeIndex + 1, (byte)i);
            lastIndex = sizeIndex;
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        private final Recycler.EnhancedHandle<AdaptiveByteBuf> handle;
        private int startIndex;
        private AbstractByteBuf rootParent;
        Chunk chunk;
        private int length;
        private int maxFastCapacity;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        AdaptiveByteBuf(Recycler.EnhancedHandle<AdaptiveByteBuf> recyclerHandle) {
            super(0);
            this.handle = (Recycler.EnhancedHandle)ObjectUtil.checkNotNull(recyclerHandle, (String)"recyclerHandle");
        }

        void init(AbstractByteBuf unwrapped, Chunk wrapped, int readerIndex, int writerIndex, int startIndex, int size, int capacity, int maxCapacity) {
            this.startIndex = startIndex;
            this.chunk = wrapped;
            this.length = size;
            this.maxFastCapacity = capacity;
            this.maxCapacity(maxCapacity);
            this.setIndex0(readerIndex, writerIndex);
            this.hasArray = unwrapped.hasArray();
            this.hasMemoryAddress = unwrapped.hasMemoryAddress();
            this.rootParent = unwrapped;
            this.tmpNioBuf = null;
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf rootParent = this.rootParent;
            if (rootParent != null) {
                return rootParent;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public int maxFastWritableBytes() {
            return Math.min(this.maxFastCapacity, this.maxCapacity()) - this.writerIndex;
        }

        @Override
        public ByteBuf capacity(int newCapacity) {
            if (this.length <= newCapacity && newCapacity <= this.maxFastCapacity) {
                this.ensureAccessible();
                this.length = newCapacity;
                return this;
            }
            this.checkNewCapacity(newCapacity);
            if (newCapacity < this.capacity()) {
                this.length = newCapacity;
                this.trimIndicesToCapacity(newCapacity);
                return this;
            }
            Chunk chunk = this.chunk;
            AdaptivePoolingAllocator allocator = chunk.allocator;
            int readerIndex = this.readerIndex;
            int writerIndex = this.writerIndex;
            int baseOldRootIndex = this.startIndex;
            int oldLength = this.length;
            int oldCapacity = this.maxFastCapacity;
            AbstractByteBuf oldRoot = this.rootParent();
            allocator.reallocate(newCapacity, this.maxCapacity(), this);
            oldRoot.getBytes(baseOldRootIndex, this, 0, oldLength);
            chunk.releaseSegment(baseOldRootIndex, oldCapacity);
            assert (oldCapacity < this.maxFastCapacity && newCapacity <= this.maxFastCapacity) : "Capacity increase failed";
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.startIndex;
        }

        @Override
        public ByteBuffer nioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent().nioBuffer(this.idx(index), length);
        }

        @Override
        public ByteBuffer internalNioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return (ByteBuffer)this.internalNioBuffer().position(index).limit(index + length);
        }

        private ByteBuffer internalNioBuffer() {
            if (this.tmpNioBuf == null) {
                this.tmpNioBuf = this.rootParent().nioBuffer(this.startIndex, this.maxFastCapacity);
            }
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent().nioBuffers(this.idx(index), length);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public ByteBuf copy(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent().copy(this.idx(index), length);
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int index) {
            return this.rootParent()._getByte(this.idx(index));
        }

        @Override
        protected short _getShort(int index) {
            return this.rootParent()._getShort(this.idx(index));
        }

        @Override
        protected short _getShortLE(int index) {
            return this.rootParent()._getShortLE(this.idx(index));
        }

        @Override
        protected int _getUnsignedMedium(int index) {
            return this.rootParent()._getUnsignedMedium(this.idx(index));
        }

        @Override
        protected int _getUnsignedMediumLE(int index) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(index));
        }

        @Override
        protected int _getInt(int index) {
            return this.rootParent()._getInt(this.idx(index));
        }

        @Override
        protected int _getIntLE(int index) {
            return this.rootParent()._getIntLE(this.idx(index));
        }

        @Override
        protected long _getLong(int index) {
            return this.rootParent()._getLong(this.idx(index));
        }

        @Override
        protected long _getLongLE(int index) {
            return this.rootParent()._getLongLE(this.idx(index));
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuffer dst) {
            this.checkIndex(index, dst.remaining());
            this.rootParent().getBytes(this.idx(index), dst);
            return this;
        }

        @Override
        protected void _setByte(int index, int value) {
            this.rootParent()._setByte(this.idx(index), value);
        }

        @Override
        protected void _setShort(int index, int value) {
            this.rootParent()._setShort(this.idx(index), value);
        }

        @Override
        protected void _setShortLE(int index, int value) {
            this.rootParent()._setShortLE(this.idx(index), value);
        }

        @Override
        protected void _setMedium(int index, int value) {
            this.rootParent()._setMedium(this.idx(index), value);
        }

        @Override
        protected void _setMediumLE(int index, int value) {
            this.rootParent()._setMediumLE(this.idx(index), value);
        }

        @Override
        protected void _setInt(int index, int value) {
            this.rootParent()._setInt(this.idx(index), value);
        }

        @Override
        protected void _setIntLE(int index, int value) {
            this.rootParent()._setIntLE(this.idx(index), value);
        }

        @Override
        protected void _setLong(int index, long value) {
            this.rootParent()._setLong(this.idx(index), value);
        }

        @Override
        protected void _setLongLE(int index, long value) {
            this.rootParent().setLongLE(this.idx(index), value);
        }

        @Override
        public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
            this.checkIndex(index, length);
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index);
            tmp.put(src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            this.checkIndex(index, length);
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index);
            tmp.put(src.nioBuffer(srcIndex, length));
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuffer src) {
            this.checkIndex(index, src.remaining());
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index);
            tmp.put(src);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
            this.checkIndex(index, length);
            if (length != 0) {
                ByteBufUtil.readBytes(this.alloc(), this.internalNioBuffer().duplicate(), index, length, out);
            }
            return this;
        }

        @Override
        public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
            ByteBuffer buf = this.internalNioBuffer().duplicate();
            buf.clear().position(index).limit(index + length);
            return out.write(buf);
        }

        @Override
        public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
            ByteBuffer buf = this.internalNioBuffer().duplicate();
            buf.clear().position(index).limit(index + length);
            return out.write(buf, position);
        }

        @Override
        public int setBytes(int index, InputStream in, int length) throws IOException {
            this.checkIndex(index, length);
            AbstractByteBuf rootParent = this.rootParent();
            if (rootParent.hasArray()) {
                return rootParent.setBytes(this.idx(index), in, length);
            }
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            int readBytes = in.read(tmp, 0, length);
            if (readBytes <= 0) {
                return readBytes;
            }
            this.setBytes(index, tmp, 0, readBytes);
            return readBytes;
        }

        @Override
        public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index, length));
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index, length), position);
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int setCharSequence(int index, CharSequence sequence, Charset charset) {
            return this.setCharSequence0(index, sequence, charset, false);
        }

        private int setCharSequence0(int index, CharSequence sequence, Charset charset, boolean expand) {
            if (charset.equals(CharsetUtil.UTF_8)) {
                int length = ByteBufUtil.utf8MaxBytes(sequence);
                if (expand) {
                    this.ensureWritable0(length);
                    this.checkIndex0(index, length);
                } else {
                    this.checkIndex(index, length);
                }
                return ByteBufUtil.writeUtf8(this, index, length, sequence, sequence.length());
            }
            if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
                int length = sequence.length();
                if (expand) {
                    this.ensureWritable0(length);
                    this.checkIndex0(index, length);
                } else {
                    this.checkIndex(index, length);
                }
                return ByteBufUtil.writeAscii(this, index, sequence, length);
            }
            byte[] bytes = sequence.toString().getBytes(charset);
            if (expand) {
                this.ensureWritable0(bytes.length);
            }
            this.setBytes(index, bytes);
            return bytes.length;
        }

        @Override
        public int writeCharSequence(CharSequence sequence, Charset charset) {
            int written = this.setCharSequence0(this.writerIndex, sequence, charset, true);
            this.writerIndex += written;
            return written;
        }

        @Override
        public int forEachByte(int index, int length, ByteProcessor processor) {
            this.checkIndex(index, length);
            int ret = this.rootParent().forEachByte(this.idx(index), length, processor);
            return this.forEachResult(ret);
        }

        @Override
        public int forEachByteDesc(int index, int length, ByteProcessor processor) {
            this.checkIndex(index, length);
            int ret = this.rootParent().forEachByteDesc(this.idx(index), length, processor);
            return this.forEachResult(ret);
        }

        @Override
        public ByteBuf setZero(int index, int length) {
            this.checkIndex(index, length);
            this.rootParent().setZero(this.idx(index), length);
            return this;
        }

        @Override
        public ByteBuf writeZero(int length) {
            this.ensureWritable(length);
            this.rootParent().setZero(this.idx(this.writerIndex), length);
            this.writerIndex += length;
            return this;
        }

        private int forEachResult(int ret) {
            if (ret < this.startIndex) {
                return -1;
            }
            return ret - this.startIndex;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int index) {
            return index + this.startIndex;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.releaseSegment(this.startIndex, this.maxFastCapacity);
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            this.handle.unguardedRecycle((Object)this);
        }
    }

    private static final class BuddyChunk
    extends Chunk
    implements IntConsumer {
        private static final int MIN_BUDDY_SIZE = 32768;
        private static final byte IS_CLAIMED = -128;
        private static final byte HAS_CLAIMED_CHILDREN = 64;
        private static final byte SHIFT_MASK = 63;
        private static final int PACK_OFFSET_MASK = 65535;
        private static final int PACK_SIZE_SHIFT = 32 - Integer.numberOfLeadingZeros(65535);
        private final MpscIntQueue freeList;
        private final byte[] buddies;
        private final int freeListCapacity;

        BuddyChunk(AbstractByteBuf delegate, Magazine magazine) {
            super(delegate, magazine);
            int capacity = delegate.capacity();
            int capFactor = capacity / 32768;
            int tree = (capFactor << 1) - 1;
            int maxShift = Integer.numberOfTrailingZeros(capFactor);
            assert (maxShift <= 30);
            this.freeListCapacity = tree >> 1;
            this.freeList = new MpscAtomicIntegerArrayQueue(this.freeListCapacity, -1);
            this.buddies = new byte[1 + tree];
            int index = 1;
            int runLength = 1;
            int currentRun = 0;
            while (maxShift > 0) {
                this.buddies[index++] = (byte)maxShift;
                if (++currentRun != runLength) continue;
                currentRun = 0;
                runLength <<= 1;
                --maxShift;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readInitInto(AdaptiveByteBuf buf, int size, int startingCapacity, int maxCapacity) {
            int startIndex;
            if (!this.freeList.isEmpty()) {
                this.freeList.drain(this.freeListCapacity, (IntConsumer)this);
            }
            if ((startIndex = this.chooseFirstFreeBuddy(1, startingCapacity, 0)) == -1) {
                return false;
            }
            BuddyChunk chunk = this;
            chunk.retain();
            try {
                buf.init(this.delegate, this, 0, 0, startIndex, size, startingCapacity, maxCapacity);
                this.allocatedBytes += startingCapacity;
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    chunk.release();
                }
            }
            return true;
        }

        public void accept(int packed) {
            int size = 32768 << (packed >> PACK_SIZE_SHIFT);
            int offset = (packed & 0xFFFF) * 32768;
            this.unreserveMatchingBuddy(1, size, offset, 0);
            this.allocatedBytes -= size;
        }

        @Override
        void releaseSegment(int startingIndex, int size) {
            int packedOffset = startingIndex / 32768;
            int packedSize = Integer.numberOfTrailingZeros(size / 32768) << PACK_SIZE_SHIFT;
            int packed = packedOffset | packedSize;
            this.freeList.offer(packed);
            this.release();
        }

        @Override
        public int remainingCapacity() {
            if (!this.freeList.isEmpty()) {
                this.freeList.drain(this.freeListCapacity, (IntConsumer)this);
            }
            return super.remainingCapacity();
        }

        @Override
        public boolean hasUnprocessedFreelistEntries() {
            return !this.freeList.isEmpty();
        }

        @Override
        public void processFreelistEntries() {
            this.freeList.drain(this.freeListCapacity, (IntConsumer)this);
        }

        private int chooseFirstFreeBuddy(int index, int size, int currOffset) {
            byte[] buddies = this.buddies;
            while (index < buddies.length) {
                byte buddy = buddies[index];
                int currValue = 32768 << (buddy & 0x3F);
                if (currValue < size || (buddy & 0xFFFFFF80) == -128) {
                    return -1;
                }
                if (currValue == size && (buddy & 0x40) == 0) {
                    int n = index;
                    buddies[n] = (byte)(buddies[n] | 0xFFFFFF80);
                    return currOffset;
                }
                int found = this.chooseFirstFreeBuddy(index << 1, size, currOffset);
                if (found != -1) {
                    int n = index;
                    buddies[n] = (byte)(buddies[n] | 0x40);
                    return found;
                }
                index = (index << 1) + 1;
                currOffset += currValue >> 1;
            }
            return -1;
        }

        private boolean unreserveMatchingBuddy(int index, int size, int offset, int currOffset) {
            byte sibling;
            int siblingIndex;
            boolean claims;
            byte[] buddies = this.buddies;
            if (buddies.length <= index) {
                return false;
            }
            byte buddy = buddies[index];
            int currSize = 32768 << (buddy & 0x3F);
            if (currSize == size) {
                if (currOffset == offset) {
                    int n = index;
                    buddies[n] = (byte)(buddies[n] & 0x3F);
                    return false;
                }
                throw new IllegalStateException("The intended segment was not found at index " + index + ", for size " + size + " and offset " + offset);
            }
            if (offset < currOffset + (currSize >> 1)) {
                claims = this.unreserveMatchingBuddy(index << 1, size, offset, currOffset);
                siblingIndex = (index << 1) + 1;
            } else {
                claims = this.unreserveMatchingBuddy((index << 1) + 1, size, offset, currOffset + (currSize >> 1));
                siblingIndex = index << 1;
            }
            if (!claims && ((sibling = buddies[siblingIndex]) & 0x3F) == sibling) {
                int n = index;
                buddies[n] = (byte)(buddies[n] & 0x3F);
                return false;
            }
            return true;
        }

        public String toString() {
            int capacity = this.delegate.capacity();
            int remaining = capacity - this.allocatedBytes;
            return "BuddyChunk[capacity: " + capacity + ", remaining: " + remaining + ", free list: " + this.freeList.size() + ']';
        }
    }

    private static final class SizeClassedChunk
    extends Chunk {
        private static final int FREE_LIST_EMPTY = -1;
        private final int segmentSize;
        private final MpscIntQueue externalFreeList;
        private final IntStack localFreeList;
        private Thread ownerThread;

        SizeClassedChunk(AbstractByteBuf delegate, Magazine magazine, SizeClassChunkController controller) {
            super(delegate, magazine);
            this.segmentSize = controller.segmentSize;
            this.ownerThread = magazine.group.ownerThread;
            if (this.ownerThread == null) {
                this.externalFreeList = controller.createFreeList();
                this.localFreeList = null;
            } else {
                this.externalFreeList = controller.createEmptyFreeList();
                this.localFreeList = controller.createLocalFreeList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readInitInto(AdaptiveByteBuf buf, int size, int startingCapacity, int maxCapacity) {
            int startIndex = this.nextAvailableSegmentOffset();
            if (startIndex == -1) {
                return false;
            }
            this.allocatedBytes += this.segmentSize;
            SizeClassedChunk chunk = this;
            chunk.retain();
            try {
                buf.init(this.delegate, chunk, 0, 0, startIndex, size, startingCapacity, maxCapacity);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes -= this.segmentSize;
                    ((Chunk)chunk).releaseSegment(startIndex, startingCapacity);
                }
            }
            return true;
        }

        private int nextAvailableSegmentOffset() {
            int startIndex;
            IntStack localFreeList = this.localFreeList;
            if (localFreeList != null) {
                assert (Thread.currentThread() == this.ownerThread);
                startIndex = localFreeList.isEmpty() ? this.externalFreeList.poll() : localFreeList.pop();
            } else {
                startIndex = this.externalFreeList.poll();
            }
            return startIndex;
        }

        private int remainingCapacityOnFreeList() {
            int segmentSize = this.segmentSize;
            int remainingCapacity = this.externalFreeList.size() * segmentSize;
            IntStack localFreeList = this.localFreeList;
            if (localFreeList != null) {
                assert (Thread.currentThread() == this.ownerThread);
                remainingCapacity += localFreeList.size() * segmentSize;
            }
            return remainingCapacity;
        }

        @Override
        public int remainingCapacity() {
            int remainingCapacity = super.remainingCapacity();
            if (remainingCapacity > this.segmentSize) {
                return remainingCapacity;
            }
            int updatedRemainingCapacity = this.remainingCapacityOnFreeList();
            if (updatedRemainingCapacity == remainingCapacity) {
                return remainingCapacity;
            }
            this.allocatedBytes = this.capacity() - updatedRemainingCapacity;
            return updatedRemainingCapacity;
        }

        private void releaseSegmentOffsetIntoFreeList(int startIndex) {
            IntStack localFreeList = this.localFreeList;
            if (localFreeList != null && Thread.currentThread() == this.ownerThread) {
                localFreeList.push(startIndex);
            } else {
                boolean segmentReturned = this.externalFreeList.offer(startIndex);
                assert (segmentReturned) : "Unable to return segment " + startIndex + " to free list";
            }
        }

        @Override
        void releaseSegment(int startIndex, int size) {
            this.release();
            this.releaseSegmentOffsetIntoFreeList(startIndex);
        }
    }

    private static final class IntStack {
        private final int[] stack;
        private int top;

        IntStack(int[] initialValues) {
            this.stack = initialValues;
            this.top = initialValues.length - 1;
        }

        public boolean isEmpty() {
            return this.top == -1;
        }

        public int pop() {
            int last = this.stack[this.top];
            --this.top;
            return last;
        }

        public void push(int value) {
            this.stack[this.top + 1] = value;
            ++this.top;
        }

        public int size() {
            return this.top + 1;
        }
    }

    private static class Chunk
    implements ReferenceCounted {
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, (String)"refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        protected final AbstractByteBuf delegate;
        protected Magazine magazine;
        private final AdaptivePoolingAllocator allocator;
        private final int capacity;
        protected int allocatedBytes;
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            protected AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            protected long unsafeOffset() {
                return PlatformDependent.hasUnsafe() ? REFCNT_FIELD_OFFSET : -1L;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.allocator = null;
            this.capacity = 0;
        }

        Chunk(AbstractByteBuf delegate, Magazine magazine) {
            this.delegate = delegate;
            this.capacity = delegate.capacity();
            updater.setInitialValue((ReferenceCounted)this);
            this.attachToMagazine(magazine);
            this.allocator = magazine.group.allocator;
        }

        Magazine currentMagazine() {
            return this.magazine;
        }

        void detachFromMagazine() {
            if (this.magazine != null) {
                this.magazine = null;
            }
        }

        void attachToMagazine(Magazine magazine) {
            assert (this.magazine == null);
            this.magazine = magazine;
        }

        public Chunk touch(Object hint) {
            return this;
        }

        public int refCnt() {
            return updater.refCnt((ReferenceCounted)this);
        }

        public Chunk retain() {
            return (Chunk)updater.retain((ReferenceCounted)this);
        }

        public Chunk retain(int increment) {
            return (Chunk)updater.retain((ReferenceCounted)this, increment);
        }

        public Chunk touch() {
            return this;
        }

        public boolean release() {
            if (updater.release((ReferenceCounted)this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        public boolean release(int decrement) {
            if (updater.release((ReferenceCounted)this, decrement)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        boolean releaseFromMagazine() {
            Magazine mag = this.magazine;
            this.detachFromMagazine();
            if (!mag.offerToQueue(this)) {
                return this.release();
            }
            return false;
        }

        void releaseSegment(int ignoredSegmentId, int size) {
            this.release();
        }

        protected void deallocate() {
            this.allocator.chunkRegistry.remove(this);
            this.delegate.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean readInitInto(AdaptiveByteBuf buf, int size, int startingCapacity, int maxCapacity) {
            int startIndex = this.allocatedBytes;
            this.allocatedBytes = startIndex + startingCapacity;
            Chunk chunk = this;
            chunk.retain();
            try {
                buf.init(this.delegate, chunk, 0, 0, startIndex, size, startingCapacity, maxCapacity);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes = startIndex;
                    chunk.release();
                }
            }
            return true;
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public boolean hasUnprocessedFreelistEntries() {
            return false;
        }

        public void processFreelistEntries() {
        }

        public int capacity() {
            return this.capacity;
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static final class ChunkRegistry {
        private final LongAdder totalCapacity = new LongAdder();

        private ChunkRegistry() {
        }

        public long totalCapacity() {
            return this.totalCapacity.sum();
        }

        public void add(Chunk chunk) {
            this.totalCapacity.add(chunk.capacity());
        }

        public void remove(Chunk chunk) {
            this.totalCapacity.add(-chunk.capacity());
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static final class Magazine {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private static final AdaptiveRecycler EVENT_LOOP_LOCAL_BUFFER_POOL = AdaptiveRecycler.threadLocal();
        private Chunk current;
        private volatile Chunk nextInLine;
        private final MagazineGroup group;
        private final ChunkController chunkController;
        private final StampedLock allocationLock;
        private final AdaptiveRecycler recycler;

        Magazine(MagazineGroup group, boolean shareable, ChunkController chunkController) {
            this.group = group;
            this.chunkController = chunkController;
            if (shareable) {
                this.allocationLock = new StampedLock();
                this.recycler = AdaptiveRecycler.sharedWith(MAGAZINE_BUFFER_QUEUE_CAPACITY);
            } else {
                this.allocationLock = null;
                this.recycler = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int size, int maxCapacity, AdaptiveByteBuf buf, boolean reallocate) {
            if (this.allocationLock == null) {
                return this.allocate(size, maxCapacity, buf, reallocate);
            }
            long writeLock = this.allocationLock.tryWriteLock();
            if (writeLock != 0L) {
                try {
                    boolean bl = this.allocate(size, maxCapacity, buf, reallocate);
                    return bl;
                }
                finally {
                    this.allocationLock.unlockWrite(writeLock);
                }
            }
            return this.allocateWithoutLock(size, maxCapacity, buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocateWithoutLock(int size, int maxCapacity, AdaptiveByteBuf buf) {
            Chunk curr = NEXT_IN_LINE.getAndSet(this, null);
            if (curr == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
            if (curr == null) {
                curr = this.group.pollChunk(size);
                if (curr == null) {
                    return false;
                }
                curr.attachToMagazine(this);
            }
            boolean allocated = false;
            int remainingCapacity = curr.remainingCapacity();
            int startingCapacity = this.chunkController.computeBufferCapacity(size, maxCapacity, true);
            if (remainingCapacity >= size && curr.readInitInto(buf, size, Math.min(remainingCapacity, startingCapacity), maxCapacity)) {
                allocated = true;
                remainingCapacity = curr.remainingCapacity();
            }
            try {
                if (remainingCapacity >= 256) {
                    this.transferToNextInLineOrRelease(curr);
                    curr = null;
                }
            }
            finally {
                if (curr != null) {
                    curr.releaseFromMagazine();
                }
            }
            return allocated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int size, int maxCapacity, AdaptiveByteBuf buf, boolean reallocate) {
            int remainingCapacity;
            int remainingCapacity2;
            boolean success;
            int startingCapacity = this.chunkController.computeBufferCapacity(size, maxCapacity, reallocate);
            Chunk curr = this.current;
            if (curr != null) {
                success = curr.readInitInto(buf, size, startingCapacity, maxCapacity);
                remainingCapacity2 = curr.remainingCapacity();
                if (!success && remainingCapacity2 > 0) {
                    this.current = null;
                    this.transferToNextInLineOrRelease(curr);
                } else if (remainingCapacity2 == 0) {
                    this.current = null;
                    curr.releaseFromMagazine();
                }
                if (success) {
                    return true;
                }
            }
            assert (this.current == null);
            curr = NEXT_IN_LINE.getAndSet(this, null);
            if (curr != null) {
                if (curr == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
                remainingCapacity = curr.remainingCapacity();
                if (remainingCapacity > startingCapacity && curr.readInitInto(buf, size, startingCapacity, maxCapacity)) {
                    this.current = curr;
                    return true;
                }
                try {
                    if (remainingCapacity >= size) {
                        remainingCapacity2 = curr.readInitInto(buf, size, remainingCapacity, maxCapacity) ? 1 : 0;
                        return remainingCapacity2 != 0;
                    }
                }
                finally {
                    curr.releaseFromMagazine();
                }
            }
            if ((curr = this.group.pollChunk(size)) == null) {
                curr = this.chunkController.newChunkAllocation(size, this);
            } else {
                curr.attachToMagazine(this);
                remainingCapacity = curr.remainingCapacity();
                if (remainingCapacity == 0 || remainingCapacity < size) {
                    if (remainingCapacity < 256) {
                        curr.releaseFromMagazine();
                    } else {
                        this.transferToNextInLineOrRelease(curr);
                    }
                    curr = this.chunkController.newChunkAllocation(size, this);
                }
            }
            this.current = curr;
            try {
                remainingCapacity2 = curr.remainingCapacity();
                assert (remainingCapacity2 >= size);
                if (remainingCapacity2 > startingCapacity) {
                    success = curr.readInitInto(buf, size, startingCapacity, maxCapacity);
                    curr = null;
                } else {
                    success = curr.readInitInto(buf, size, remainingCapacity2, maxCapacity);
                }
            }
            finally {
                if (curr != null) {
                    curr.releaseFromMagazine();
                    this.current = null;
                }
            }
            return success;
        }

        private void restoreMagazineFreed() {
            Chunk next = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (next != null && next != MAGAZINE_FREED) {
                next.releaseFromMagazine();
            }
        }

        private void transferToNextInLineOrRelease(Chunk chunk) {
            if (NEXT_IN_LINE.compareAndSet(this, null, chunk)) {
                return;
            }
            Chunk nextChunk = NEXT_IN_LINE.get(this);
            if (nextChunk != null && nextChunk != MAGAZINE_FREED && chunk.remainingCapacity() > nextChunk.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, nextChunk, chunk)) {
                nextChunk.releaseFromMagazine();
                return;
            }
            chunk.releaseFromMagazine();
        }

        void free() {
            this.restoreMagazineFreed();
            long stamp = this.allocationLock != null ? this.allocationLock.writeLock() : 0L;
            try {
                if (this.current != null) {
                    this.current.releaseFromMagazine();
                    this.current = null;
                }
            }
            finally {
                if (this.allocationLock != null) {
                    this.allocationLock.unlockWrite(stamp);
                }
            }
        }

        public AdaptiveByteBuf newBuffer() {
            AdaptiveRecycler recycler = this.recycler;
            AdaptiveByteBuf buf = recycler == null ? (AdaptiveByteBuf)EVENT_LOOP_LOCAL_BUFFER_POOL.get() : (AdaptiveByteBuf)recycler.get();
            buf.resetRefCnt();
            buf.discardMarks();
            return buf;
        }

        boolean offerToQueue(Chunk chunk) {
            return this.group.offerChunk(chunk);
        }

        private static final class AdaptiveRecycler
        extends Recycler<AdaptiveByteBuf> {
            private AdaptiveRecycler() {
            }

            private AdaptiveRecycler(int maxCapacity) {
                super(maxCapacity);
            }

            protected AdaptiveByteBuf newObject(Recycler.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf((Recycler.EnhancedHandle<AdaptiveByteBuf>)((Recycler.EnhancedHandle)handle));
            }

            public static AdaptiveRecycler threadLocal() {
                return new AdaptiveRecycler();
            }

            public static AdaptiveRecycler sharedWith(int maxCapacity) {
                return new AdaptiveRecycler(maxCapacity);
            }
        }
    }

    private static final class BuddyChunkController
    implements ChunkController {
        private final ChunkAllocator chunkAllocator;
        private final ChunkRegistry chunkRegistry;
        private final AtomicInteger maxChunkSize;

        BuddyChunkController(MagazineGroup group, AtomicInteger maxChunkSize) {
            this.chunkAllocator = group.chunkAllocator;
            this.chunkRegistry = group.allocator.chunkRegistry;
            this.maxChunkSize = maxChunkSize;
        }

        @Override
        public int computeBufferCapacity(int requestedSize, int maxCapacity, boolean isReallocation) {
            return MathUtil.safeFindNextPositivePowerOfTwo((int)requestedSize);
        }

        @Override
        public Chunk newChunkAllocation(int promptingSize, Magazine magazine) {
            int maxChunkSize = this.maxChunkSize.get();
            int proposedChunkSize = MathUtil.safeFindNextPositivePowerOfTwo((int)(8 * promptingSize));
            int chunkSize = Math.min(MAX_CHUNK_SIZE, Math.max(maxChunkSize, proposedChunkSize));
            if (chunkSize > maxChunkSize) {
                this.maxChunkSize.set(chunkSize);
            }
            BuddyChunk chunk = new BuddyChunk(this.chunkAllocator.allocate(chunkSize, chunkSize), magazine);
            this.chunkRegistry.add(chunk);
            return chunk;
        }
    }

    private static final class BuddyChunkManagementStrategy
    implements ChunkManagementStrategy {
        private final AtomicInteger maxChunkSize = new AtomicInteger();

        private BuddyChunkManagementStrategy() {
        }

        @Override
        public ChunkController createController(MagazineGroup group) {
            return new BuddyChunkController(group, this.maxChunkSize);
        }

        @Override
        public ChunkCache createChunkCache(boolean isThreadLocal) {
            return new ConcurrentSkipListChunkCache();
        }
    }

    private static final class SizeClassChunkController
    implements ChunkController {
        private final ChunkAllocator chunkAllocator;
        private final int segmentSize;
        private final int chunkSize;
        private final ChunkRegistry chunkRegistry;

        private SizeClassChunkController(MagazineGroup group, int segmentSize, int chunkSize) {
            this.chunkAllocator = group.chunkAllocator;
            this.segmentSize = segmentSize;
            this.chunkSize = chunkSize;
            this.chunkRegistry = group.allocator.chunkRegistry;
        }

        private MpscIntQueue createEmptyFreeList() {
            return new MpscAtomicIntegerArrayQueue(this.chunkSize / this.segmentSize, -1);
        }

        private MpscIntQueue createFreeList() {
            int segmentsCount = this.chunkSize / this.segmentSize;
            MpscAtomicIntegerArrayQueue freeList = new MpscAtomicIntegerArrayQueue(segmentsCount, -1);
            int segmentOffset = 0;
            for (int i = 0; i < segmentsCount; ++i) {
                freeList.offer(segmentOffset);
                segmentOffset += this.segmentSize;
            }
            return freeList;
        }

        private IntStack createLocalFreeList() {
            int segmentsCount = this.chunkSize / this.segmentSize;
            int segmentOffset = this.chunkSize;
            int[] offsets = new int[segmentsCount];
            for (int i = 0; i < segmentsCount; ++i) {
                offsets[i] = segmentOffset -= this.segmentSize;
            }
            return new IntStack(offsets);
        }

        @Override
        public int computeBufferCapacity(int requestedSize, int maxCapacity, boolean isReallocation) {
            return Math.min(this.segmentSize, maxCapacity);
        }

        @Override
        public Chunk newChunkAllocation(int promptingSize, Magazine magazine) {
            AbstractByteBuf chunkBuffer = this.chunkAllocator.allocate(this.chunkSize, this.chunkSize);
            assert (chunkBuffer.capacity() == this.chunkSize);
            SizeClassedChunk chunk = new SizeClassedChunk(chunkBuffer, magazine, this);
            this.chunkRegistry.add(chunk);
            return chunk;
        }
    }

    private static final class SizeClassChunkManagementStrategy
    implements ChunkManagementStrategy {
        private static final int MIN_SEGMENTS_PER_CHUNK = 32;
        private final int segmentSize;
        private final int chunkSize;

        private SizeClassChunkManagementStrategy(int segmentSize) {
            this.segmentSize = ObjectUtil.checkPositive((int)segmentSize, (String)"segmentSize");
            this.chunkSize = Math.max(131072, segmentSize * 32);
        }

        @Override
        public ChunkController createController(MagazineGroup group) {
            return new SizeClassChunkController(group, this.segmentSize, this.chunkSize);
        }

        @Override
        public ChunkCache createChunkCache(boolean isThreadLocal) {
            return new ConcurrentQueueChunkCache();
        }
    }

    private static interface ChunkController {
        public int computeBufferCapacity(int var1, int var2, boolean var3);

        public Chunk newChunkAllocation(int var1, Magazine var2);
    }

    private static interface ChunkManagementStrategy {
        public ChunkController createController(MagazineGroup var1);

        public ChunkCache createChunkCache(boolean var1);
    }

    private static final class ConcurrentSkipListChunkCache
    implements ChunkCache {
        private final ConcurrentSkipListIntObjMultimap<Chunk> chunks = new ConcurrentSkipListIntObjMultimap(-1);

        private ConcurrentSkipListChunkCache() {
        }

        @Override
        public Chunk pollChunk(int size) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            ConcurrentSkipListIntObjMultimap.IntEntry entry2 = this.chunks.pollCeilingEntry(size);
            if (entry2 != null) {
                Chunk chunk = (Chunk)entry2.getValue();
                if (chunk.hasUnprocessedFreelistEntries()) {
                    chunk.processFreelistEntries();
                }
                return chunk;
            }
            Chunk bestChunk = null;
            int bestRemainingCapacity = 0;
            for (ConcurrentSkipListIntObjMultimap.IntEntry entry2 : this.chunks) {
                Chunk chunk;
                if (entry2 == null || !(chunk = (Chunk)entry2.getValue()).hasUnprocessedFreelistEntries() || !this.chunks.remove(entry2.getKey(), entry2.getValue())) continue;
                chunk.processFreelistEntries();
                int remainingCapacity = chunk.remainingCapacity();
                if (remainingCapacity >= size && (bestChunk == null || remainingCapacity > bestRemainingCapacity)) {
                    if (bestChunk != null) {
                        this.chunks.put(bestRemainingCapacity, (Object)bestChunk);
                    }
                    bestChunk = chunk;
                    bestRemainingCapacity = remainingCapacity;
                    continue;
                }
                this.chunks.put(remainingCapacity, (Object)chunk);
            }
            return bestChunk;
        }

        @Override
        public boolean offerChunk(Chunk chunk) {
            this.chunks.put(chunk.remainingCapacity(), (Object)chunk);
            int size = this.chunks.size();
            while (size > CHUNK_REUSE_QUEUE) {
                int key = -1;
                Chunk toDeallocate = null;
                for (ConcurrentSkipListIntObjMultimap.IntEntry entry : this.chunks) {
                    int toDeallocateRefCnt;
                    Chunk candidate = (Chunk)entry.getValue();
                    if (candidate == null) continue;
                    if (toDeallocate == null) {
                        toDeallocate = candidate;
                        key = entry.getKey();
                        continue;
                    }
                    int candidateRefCnt = candidate.refCnt();
                    if (candidateRefCnt >= (toDeallocateRefCnt = toDeallocate.refCnt()) && (candidateRefCnt != toDeallocateRefCnt || candidate.capacity() >= toDeallocate.capacity())) continue;
                    toDeallocate = candidate;
                    key = entry.getKey();
                }
                if (toDeallocate == null) break;
                if (this.chunks.remove(key, toDeallocate)) {
                    toDeallocate.release();
                }
                size = this.chunks.size();
            }
            return true;
        }
    }

    private static final class ConcurrentQueueChunkCache
    implements ChunkCache {
        private final Queue<Chunk> queue = AdaptivePoolingAllocator.access$900();

        private ConcurrentQueueChunkCache() {
        }

        @Override
        public Chunk pollChunk(int size) {
            int attemps = this.queue.size();
            for (int i = 0; i < attemps; ++i) {
                Chunk chunk = this.queue.poll();
                if (chunk == null) {
                    return null;
                }
                if (chunk.hasUnprocessedFreelistEntries()) {
                    chunk.processFreelistEntries();
                }
                if (chunk.remainingCapacity() >= size) {
                    return chunk;
                }
                this.queue.offer(chunk);
            }
            return null;
        }

        @Override
        public boolean offerChunk(Chunk chunk) {
            return this.queue.offer(chunk);
        }
    }

    private static interface ChunkCache {
        public Chunk pollChunk(int var1);

        public boolean offerChunk(Chunk var1);
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static final class MagazineGroup {
        private final AdaptivePoolingAllocator allocator;
        private final ChunkAllocator chunkAllocator;
        private final ChunkManagementStrategy chunkManagementStrategy;
        private final ChunkCache chunkCache;
        private final StampedLock magazineExpandLock;
        private final Magazine threadLocalMagazine;
        private Thread ownerThread;
        private volatile Magazine[] magazines;
        private volatile boolean freed;

        MagazineGroup(AdaptivePoolingAllocator allocator, ChunkAllocator chunkAllocator, ChunkManagementStrategy chunkManagementStrategy, boolean isThreadLocal) {
            this.allocator = allocator;
            this.chunkAllocator = chunkAllocator;
            this.chunkManagementStrategy = chunkManagementStrategy;
            this.chunkCache = chunkManagementStrategy.createChunkCache(isThreadLocal);
            if (isThreadLocal) {
                this.ownerThread = Thread.currentThread();
                this.magazineExpandLock = null;
                this.threadLocalMagazine = new Magazine(this, false, chunkManagementStrategy.createController(this));
            } else {
                this.ownerThread = null;
                this.magazineExpandLock = new StampedLock();
                this.threadLocalMagazine = null;
                Magazine[] mags = new Magazine[1];
                for (int i = 0; i < mags.length; ++i) {
                    mags[i] = new Magazine(this, true, chunkManagementStrategy.createController(this));
                }
                this.magazines = mags;
            }
        }

        public AdaptiveByteBuf allocate(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
            Magazine[] mags;
            boolean reallocate = buf != null;
            Magazine tlMag = this.threadLocalMagazine;
            if (tlMag != null) {
                if (buf == null) {
                    buf = tlMag.newBuffer();
                }
                boolean allocated = tlMag.tryAllocate(size, maxCapacity, buf, reallocate);
                assert (allocated) : "Allocation of threadLocalMagazine must always succeed";
                return buf;
            }
            long threadId = currentThread.getId();
            int expansions = 0;
            do {
                mags = this.magazines;
                int mask = mags.length - 1;
                int index = (int)(threadId & (long)mask);
                int m = mags.length << 1;
                for (int i = 0; i < m; ++i) {
                    Magazine mag = mags[index + i & mask];
                    if (buf == null) {
                        buf = mag.newBuffer();
                    }
                    if (!mag.tryAllocate(size, maxCapacity, buf, reallocate)) continue;
                    return buf;
                }
            } while (++expansions <= 3 && this.tryExpandMagazines(mags.length));
            if (!reallocate && buf != null) {
                buf.release();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryExpandMagazines(int currentLength) {
            if (currentLength >= MAX_STRIPES) {
                return true;
            }
            long writeLock = this.magazineExpandLock.tryWriteLock();
            if (writeLock != 0L) {
                Magazine[] mags;
                try {
                    mags = this.magazines;
                    if (mags.length >= MAX_STRIPES || mags.length > currentLength || this.freed) {
                        boolean bl = true;
                        return bl;
                    }
                    Magazine[] expanded = new Magazine[mags.length * 2];
                    int l = expanded.length;
                    for (int i = 0; i < l; ++i) {
                        expanded[i] = new Magazine(this, true, this.chunkManagementStrategy.createController(this));
                    }
                    this.magazines = expanded;
                }
                finally {
                    this.magazineExpandLock.unlockWrite(writeLock);
                }
                for (Magazine magazine : mags) {
                    magazine.free();
                }
            }
            return true;
        }

        Chunk pollChunk(int size) {
            return this.chunkCache.pollChunk(size);
        }

        boolean offerChunk(Chunk chunk) {
            if (this.freed) {
                return false;
            }
            if (chunk.hasUnprocessedFreelistEntries()) {
                chunk.processFreelistEntries();
            }
            boolean isAdded = this.chunkCache.offerChunk(chunk);
            if (this.freed && isAdded) {
                this.freeChunkReuseQueue(this.ownerThread);
            }
            return isAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void free() {
            this.freed = true;
            Thread ownerThread = this.ownerThread;
            if (this.threadLocalMagazine != null) {
                this.ownerThread = null;
                this.threadLocalMagazine.free();
            } else {
                long stamp = this.magazineExpandLock.writeLock();
                try {
                    Magazine[] mags;
                    for (Magazine magazine : mags = this.magazines) {
                        magazine.free();
                    }
                }
                finally {
                    this.magazineExpandLock.unlockWrite(stamp);
                }
            }
            this.freeChunkReuseQueue(ownerThread);
        }

        private void freeChunkReuseQueue(Thread ownerThread) {
            Chunk chunk;
            while ((chunk = this.chunkCache.pollChunk(0)) != null) {
                if (ownerThread != null && chunk instanceof SizeClassedChunk) {
                    SizeClassedChunk threadLocalChunk = (SizeClassedChunk)chunk;
                    assert (ownerThread == threadLocalChunk.ownerThread);
                    threadLocalChunk.ownerThread = null;
                }
                chunk.release();
            }
        }
    }
}

