/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import org.apache.solr.common.util.Hash;

public class StringBytes {
    byte[] bytes;
    int offset;
    int length;
    private int hash;

    public StringBytes(byte[] bytes, int offset, int length) {
        this.reset(bytes, offset, length);
    }

    StringBytes reset(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.hash = bytes == null ? 0 : Hash.murmurhash3_x86_32(bytes, offset, length, 0);
        return this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof StringBytes) {
            return this.bytesEquals((StringBytes)other);
        }
        return false;
    }

    boolean bytesEquals(StringBytes other) {
        assert (other != null);
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.bytes[upto] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

