/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerContextAttributeValueNotInCondition
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerContextAttributeValueNotInCondition.class);
    protected String attributeName;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerContextAttributeValueNotInCondition.init(" + this.condition + ")");
        }
        super.init();
        Map<String, String> evalOptions = this.conditionDef.getEvaluatorOptions();
        if (MapUtils.isNotEmpty(evalOptions)) {
            this.attributeName = evalOptions.get("attributeName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerContextAttributeValueNotInCondition.init(" + this.condition + ")");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        Object val;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerContextAttributeValueNotInCondition.isMatched(" + this.condition + ")");
        }
        boolean ret = true;
        if (this.attributeName != null && this.condition != null && CollectionUtils.isNotEmpty(this.condition.getValues()) && (val = request.getContext().get(this.attributeName)) != null) {
            boolean bl = ret = !this.condition.getValues().contains(val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerContextAttributeValueNotInCondition.isMatched(" + this.condition + "): " + ret);
        }
        return ret;
    }
}

