/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.examples.sampleapp;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.apache.ranger.examples.sampleapp.DefaultAuthorizer;
import org.apache.ranger.examples.sampleapp.IAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleApp {
    private static final Logger LOG = LoggerFactory.getLogger(SampleApp.class);
    private static final Set<String> VALID_ACCESS_TYPES = new HashSet<String>();
    private IAuthorizer authorizer = null;

    public static void main(String[] args) {
        SampleApp app = new SampleApp();
        app.init();
        app.run();
    }

    public void init() {
        VALID_ACCESS_TYPES.add("read");
        VALID_ACCESS_TYPES.add("write");
        VALID_ACCESS_TYPES.add("execute");
        this.authorizer = this.createAuthorizer();
    }

    public void run() {
        String input;
        LOG.debug("==> SampleApp.run()");
        while ((input = this.getInput()) != null) {
            if (input.trim().isEmpty()) continue;
            String[] args = input.split("\\s+");
            String accessType = this.getStringArg(args, 0);
            String fileName = this.getStringArg(args, 1);
            String userName = this.getStringArg(args, 2);
            HashSet<String> userGroups = new HashSet<String>();
            for (int i = 3; i < args.length; ++i) {
                userGroups.add(args[i]);
            }
            if (fileName == null || accessType == null || userName == null) {
                LOG.info("Insufficient arguments. Usage: <accessType> <fileName> <userName> [userGroup1 userGroup2 userGroup3 ..]");
                continue;
            }
            if (!VALID_ACCESS_TYPES.contains(accessType)) {
                LOG.info(accessType + ": invalid accessType");
                continue;
            }
            if (this.authorizer.authorize(fileName, accessType, userName, userGroups)) {
                LOG.info("Authorized!");
                continue;
            }
            LOG.info("Not authorized!");
        }
        LOG.debug("<== SampleApp.run()");
    }

    private IAuthorizer createAuthorizer() {
        IAuthorizer ret = null;
        String authzClassName = System.getProperty("sampleapp.authorizer");
        if (authzClassName != null) {
            try {
                Class<?> clz = Class.forName(authzClassName);
                ret = (IAuthorizer)clz.newInstance();
            }
            catch (Exception excp) {
                LOG.warn("Failed to create authorizer of type '" + authzClassName + "'", (Throwable)excp);
            }
        }
        if (ret == null) {
            LOG.info("Using default authorizer");
            ret = new DefaultAuthorizer();
        }
        ret.init();
        return ret;
    }

    private String getStringArg(String[] args, int index) {
        if (args == null || args.length <= index) {
            return null;
        }
        return args[index];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getInput() {
        try (Scanner inputReader = new Scanner(System.in, StandardCharsets.UTF_8.name());){
            System.out.print("command> ");
            System.out.flush();
            String string = inputReader.nextLine();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

