/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class AllCircuitBreakerStats
implements Writeable,
ToXContentFragment {
    private final CircuitBreakerStats[] allStats;

    public AllCircuitBreakerStats(CircuitBreakerStats[] allStats) {
        this.allStats = allStats;
    }

    public AllCircuitBreakerStats(StreamInput in) throws IOException {
        this.allStats = in.readArray(CircuitBreakerStats::new, CircuitBreakerStats[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.allStats);
    }

    public CircuitBreakerStats[] getAllStats() {
        return this.allStats;
    }

    public CircuitBreakerStats getStats(String name) {
        for (CircuitBreakerStats stats : this.allStats) {
            if (!stats.getName().equals(name)) continue;
            return stats;
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("breakers");
        for (CircuitBreakerStats stats : this.allStats) {
            if (stats == null) continue;
            stats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String BREAKERS = "breakers";

        Fields() {
        }
    }
}

