/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.calendars;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class Calendar
implements ToXContentObject {
    public static final String CALENDAR_TYPE = "calendar";
    public static final ParseField JOB_IDS = new ParseField("job_ids", new String[0]);
    public static final ParseField ID = new ParseField("calendar_id", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ConstructingObjectParser<Calendar, Void> PARSER = new ConstructingObjectParser("calendar", true, a -> new Calendar((String)a[0], (List)a[1], (String)a[2]));
    private final String id;
    private final List<String> jobIds;
    private final String description;

    public Calendar(String id, List<String> jobIds, @Nullable String description) {
        this.id = Objects.requireNonNull(id, ID.getPreferredName() + " must not be null");
        this.jobIds = Collections.unmodifiableList(Objects.requireNonNull(jobIds, JOB_IDS.getPreferredName() + " must not be null"));
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(JOB_IDS.getPreferredName(), this.jobIds);
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Calendar other = (Calendar)obj;
        return this.id.equals(other.id) && this.jobIds.equals(other.jobIds) && Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobIds, this.description);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), JOB_IDS);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION);
    }
}

