/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.model.notification.MessageSource;
import org.apache.atlas.model.notification.MessageVersion;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasNotificationBaseMessage {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasNotificationBaseMessage.class);
    public static final int MESSAGE_MAX_LENGTH_BYTES = AtlasConfiguration.NOTIFICATION_MESSAGE_MAX_LENGTH_BYTES.getInt() - 512;
    public static final boolean MESSAGE_COMPRESSION_ENABLED = AtlasConfiguration.NOTIFICATION_MESSAGE_COMPRESSION_ENABLED.getBoolean();
    private MessageSource source = null;
    private MessageVersion version = null;
    private String msgId = null;
    private CompressionKind msgCompressionKind = CompressionKind.NONE;
    private int msgSplitIdx = 1;
    private int msgSplitCount = 1;

    public AtlasNotificationBaseMessage() {
    }

    public AtlasNotificationBaseMessage(MessageVersion version) {
        this(version, null, CompressionKind.NONE);
    }

    public AtlasNotificationBaseMessage(MessageVersion version, String msgId, CompressionKind msgCompressionKind) {
        this(version, msgId, msgCompressionKind, null);
    }

    public AtlasNotificationBaseMessage(MessageVersion version, MessageSource source) {
        this(version, null, CompressionKind.NONE, source);
    }

    public AtlasNotificationBaseMessage(MessageVersion version, String msgId, CompressionKind msgCompressionKind, MessageSource source) {
        this.version = version;
        this.msgId = msgId;
        this.msgCompressionKind = msgCompressionKind;
        this.source = source;
    }

    public AtlasNotificationBaseMessage(MessageVersion version, String msgId, CompressionKind msgCompressionKind, int msgSplitIdx, int msgSplitCount) {
        this.version = version;
        this.msgId = msgId;
        this.msgCompressionKind = msgCompressionKind;
        this.msgSplitIdx = msgSplitIdx;
        this.msgSplitCount = msgSplitCount;
    }

    public void setVersion(MessageVersion version) {
        this.version = version;
    }

    public MessageVersion getVersion() {
        return this.version;
    }

    public void setSource(MessageSource source) {
        this.source = source;
    }

    public MessageSource getSource() {
        return this.source;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public CompressionKind getMsgCompressionKind() {
        return this.msgCompressionKind;
    }

    public void setMsgCompressed(CompressionKind msgCompressionKind) {
        this.msgCompressionKind = msgCompressionKind;
    }

    public int getMsgSplitIdx() {
        return this.msgSplitIdx;
    }

    public void setMsgSplitIdx(int msgSplitIdx) {
        this.msgSplitIdx = msgSplitIdx;
    }

    public int getMsgSplitCount() {
        return this.msgSplitCount;
    }

    public void setMsgSplitCount(int msgSplitCount) {
        this.msgSplitCount = msgSplitCount;
    }

    public int compareVersion(MessageVersion compareToVersion) {
        return this.version.compareTo(compareToVersion);
    }

    public static byte[] getBytesUtf8(String str) {
        return StringUtils.getBytesUtf8((String)str);
    }

    public static String getStringUtf8(byte[] bytes) {
        return StringUtils.newStringUtf8((byte[])bytes);
    }

    public static byte[] encodeBase64(byte[] bytes) {
        return Base64.encodeBase64((byte[])bytes);
    }

    public static byte[] decodeBase64(byte[] bytes) {
        return Base64.decodeBase64((byte[])bytes);
    }

    public static byte[] gzipCompressAndEncodeBase64(byte[] bytes) {
        return AtlasNotificationBaseMessage.encodeBase64(AtlasNotificationBaseMessage.gzipCompress(bytes));
    }

    public static byte[] decodeBase64AndGzipUncompress(byte[] bytes) {
        return AtlasNotificationBaseMessage.gzipUncompress(AtlasNotificationBaseMessage.decodeBase64(bytes));
    }

    public static String gzipCompress(String str) {
        byte[] bytes = AtlasNotificationBaseMessage.getBytesUtf8(str);
        byte[] compressedBytes = AtlasNotificationBaseMessage.gzipCompress(bytes);
        byte[] encodedBytes = AtlasNotificationBaseMessage.encodeBase64(compressedBytes);
        return AtlasNotificationBaseMessage.getStringUtf8(encodedBytes);
    }

    public static String gzipUncompress(String str) {
        byte[] encodedBytes = AtlasNotificationBaseMessage.getBytesUtf8(str);
        byte[] compressedBytes = AtlasNotificationBaseMessage.decodeBase64(encodedBytes);
        byte[] bytes = AtlasNotificationBaseMessage.gzipUncompress(compressedBytes);
        return AtlasNotificationBaseMessage.getStringUtf8(bytes);
    }

    public static byte[] gzipCompress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            LOG.error("gzipCompress(): error compressing {} bytes", (Object)content.length, (Object)e);
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gzipUncompress(byte[] content) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)new GZIPInputStream(new ByteArrayInputStream(content)), (OutputStream)out);
        }
        catch (IOException e) {
            LOG.error("gzipUncompress(): error uncompressing {} bytes", (Object)content.length, (Object)e);
        }
        return out.toByteArray();
    }

    public static enum CompressionKind {
        NONE,
        GZIP;

    }
}

