/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.SortOrder;
import java.util.Objects;
import java.util.StringJoiner;

public class SortItem {
    private final String name;
    private final SortOrder sortOrder;

    @JsonCreator
    public SortItem(String name, SortOrder sortOrder) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return this.name.equals(sortItem.name) && this.sortOrder == sortItem.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sortOrder});
    }

    public String toString() {
        return new StringJoiner(", ", SortItem.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("sortOrder=" + String.valueOf((Object)this.sortOrder)).toString();
    }
}

