/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.Slices;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public final class CharType
extends AbstractVariableWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.builder(Slice.class).addOperators(DEFAULT_READ_OPERATORS).addOperators(DEFAULT_COMPARABLE_OPERATORS).addOperators(CharType.class, MethodHandles.lookup()).build();
    public static final int MAX_LENGTH = 65536;
    private static final CharType[] CACHED_INSTANCES = new CharType[128];
    private final int length;
    private volatile Optional<Type.Range> range;

    public static CharType createCharType(int length) {
        if (0 <= length && length < CACHED_INSTANCES.length) {
            return CACHED_INSTANCES[length];
        }
        return new CharType(length);
    }

    private CharType(int length) {
        super(new TypeSignature("char", Collections.singletonList(TypeSignatureParameter.numericParameter(length))), Slice.class);
        if (length < 0 || length > 65536) {
            throw new IllegalArgumentException(String.format("CHAR length must be in range [0, %s], got %s", 65536, length));
        }
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Optional<Type.Range> getRange() {
        boolean cachedRangePresent;
        Optional<Type.Range> range = this.range;
        boolean bl = cachedRangePresent = range != null;
        if (!cachedRangePresent) {
            if (this.length > 100) {
                range = Optional.empty();
            } else {
                int i;
                int minCodePointSize = SliceUtf8.lengthOfCodePoint((int)0);
                int maxCodePointSize = SliceUtf8.lengthOfCodePoint((int)0x10FFFF);
                Slice min = io.airlift.slice.Slices.allocate((int)(minCodePointSize * this.length));
                Slice max = io.airlift.slice.Slices.allocate((int)(maxCodePointSize * this.length));
                int position = 0;
                for (i = 0; i < this.length; ++i) {
                    position += SliceUtf8.setCodePointAt((int)0, (Slice)min, (int)position);
                }
                position = 0;
                for (i = 0; i < this.length; ++i) {
                    position += SliceUtf8.setCodePointAt((int)0x10FFFF, (Slice)max, (int)position);
                }
                range = Optional.of(new Type.Range(min, max));
            }
            this.range = range;
        }
        return range;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = this.getSlice(block, position);
        if (slice.length() > 0) {
            if (SliceUtf8.countCodePoints((Slice)slice) > this.length) {
                throw new IllegalArgumentException(String.format("Character count exceeds length limit %s: %s", this.length, Slices.sliceRepresentation(slice)));
            }
            if (slice.getByte(slice.length() - 1) == 32) {
                throw new IllegalArgumentException(String.format("Value representation has a trailing space: %s", Slices.sliceRepresentation(slice)));
            }
        }
        return Chars.padSpaces(slice, this.length).toStringUtf8();
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, Math.min(this.length, 32));
    }

    @Override
    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, io.airlift.slice.Slices.utf8Slice((String)value));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length > 0 && value.getByte(offset + length - 1) == 32) {
            throw new IllegalArgumentException("Slice representing Char should not have trailing spaces");
        }
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharType other = (CharType)o;
        return this.length == other.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Slice left, Slice right) {
        return Chars.compareChars(left, right);
    }

    static {
        for (int i = 0; i < CACHED_INSTANCES.length; ++i) {
            CharType.CACHED_INSTANCES[i] = new CharType(i);
        }
    }
}

