/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.ozone.util.MutableMinMax;
import org.apache.hadoop.ozone.util.PerformanceMetricsInitializer;

public class PerformanceMetrics
implements Closeable {
    private final MutableStat stat;
    private final List<MutableQuantiles> quantiles;
    private final MutableMinMax minMax;

    public static synchronized <T> Map<String, PerformanceMetrics> initializeMetrics(T source, MetricsRegistry registry, String sampleName, String valueName, int[] intervals) {
        try {
            return PerformanceMetricsInitializer.initialize(source, registry, sampleName, valueName, intervals);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize PerformanceMetrics", e);
        }
    }

    public PerformanceMetrics(MetricsRegistry registry, String name, String description, String sampleName, String valueName, int[] intervals) {
        this.stat = registry.newStat(name, description, sampleName, valueName, false);
        this.quantiles = MetricUtil.createQuantiles(registry, name, description, sampleName, valueName, intervals);
        this.minMax = new MutableMinMax(registry, name, description, valueName);
    }

    @Override
    public void close() {
        MetricUtil.stop(this.quantiles);
    }

    public void add(long value) {
        this.stat.add(value);
        this.quantiles.forEach(quantile -> quantile.add(value));
        this.minMax.add(value);
    }

    public void snapshot(MetricsRecordBuilder recordBuilder, boolean all) {
        this.stat.snapshot(recordBuilder, all);
        this.quantiles.forEach(quantile -> quantile.snapshot(recordBuilder, all));
        this.minMax.snapshot(recordBuilder, all);
    }
}

