/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerResourceInfo {
    private String name;
    private Set<String> subResources;
    private ResourceMatchScope nameMatchScope;
    private Map<String, Object> attributes;

    public RangerResourceInfo() {
    }

    public RangerResourceInfo(String name, Set<String> subResources, ResourceMatchScope nameMatchScope, Map<String, Object> attributes) {
        this.name = name;
        this.subResources = subResources;
        this.nameMatchScope = nameMatchScope;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(Set<String> subResources) {
        this.subResources = subResources;
    }

    public ResourceMatchScope getNameMatchScope() {
        return this.nameMatchScope;
    }

    public void setNameMatchScope(ResourceMatchScope nameMatchScope) {
        this.nameMatchScope = nameMatchScope;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.subResources, this.nameMatchScope, this.attributes});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerResourceInfo that = (RangerResourceInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.subResources, that.subResources) && Objects.equals((Object)this.nameMatchScope, (Object)that.nameMatchScope) && Objects.equals(this.attributes, that.attributes);
    }

    public String toString() {
        return "RangerResourceInfo{name='" + this.name + '\'' + ", subResources=" + this.subResources + ", nameMatchScope=" + (Object)((Object)this.nameMatchScope) + ", attributes=" + this.attributes + '}';
    }

    public static enum ResourceMatchScope {
        SELF,
        SELF_OR_ANY_CHILD,
        SELF_OR_ANY_DESCENDANT;

    }
}

