/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.IncrementalClusterStateWriter;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GatewayMetaState
implements Closeable {
    public static final String STALE_STATE_CONFIG_NODE_ID = "STALE_STATE_CONFIG";
    private final SetOnce<CoordinationState.PersistedState> persistedState = new SetOnce();

    public CoordinationState.PersistedState getPersistedState() {
        CoordinationState.PersistedState persistedState = (CoordinationState.PersistedState)this.persistedState.get();
        assert (persistedState != null) : "not started";
        return persistedState;
    }

    public Metadata getMetadata() {
        return this.getPersistedState().getLastAcceptedState().metadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Settings settings, TransportService transportService, ClusterService clusterService, MetaStateService metaStateService, IndexMetadataVerifier indexMetadataVerifier, MetadataUpgrader metadataUpgrader, PersistedClusterStateService persistedClusterStateService) {
        assert (this.persistedState.get() == null) : "should only start once, but already have " + this.persistedState.get();
        if (DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings).equals("legacy-zen-for-testing-only-do-not-use")) {
            Tuple<Manifest, Metadata> manifestClusterStateTuple;
            try {
                NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT, Version.V_EMPTY), persistedClusterStateService.getDataPaths());
                manifestClusterStateTuple = metaStateService.loadFullState();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ClusterState clusterState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).version(((Manifest)manifestClusterStateTuple.v1()).getClusterStateVersion()).metadata((Metadata)manifestClusterStateTuple.v2()).build();
            try {
                NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT, clusterState.metadata().oldestIndexVersion()), persistedClusterStateService.getDataPaths());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            IncrementalClusterStateWriter incrementalClusterStateWriter = new IncrementalClusterStateWriter(settings, clusterService.getClusterSettings(), metaStateService, (Manifest)manifestClusterStateTuple.v1(), this.prepareInitialClusterState(transportService, clusterService, clusterState), transportService.getThreadPool()::relativeTimeInMillis);
            if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.canContainData(settings)) {
                clusterService.addLowPriorityApplier(new GatewayClusterApplier(incrementalClusterStateWriter));
            }
            this.persistedState.set((Object)new InMemoryPersistedState(((Manifest)manifestClusterStateTuple.v1()).getCurrentTerm(), clusterState));
            return;
        }
        if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.canContainData(settings)) {
            try {
                void var14_25;
                block30: {
                    PersistedClusterStateService.OnDiskState onDiskState = persistedClusterStateService.loadBestOnDiskState();
                    Metadata metadata = onDiskState.metadata;
                    long lastAcceptedVersion = onDiskState.lastAcceptedVersion;
                    long currentTerm = onDiskState.currentTerm;
                    if (onDiskState.empty()) {
                        assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "legacy metadata loader is not needed anymore from v9 onwards";
                        Tuple<Manifest, Metadata> tuple = metaStateService.loadFullState();
                        if (!((Manifest)tuple.v1()).isEmpty()) {
                            metadata = (Metadata)tuple.v2();
                            lastAcceptedVersion = ((Manifest)tuple.v1()).getClusterStateVersion();
                            currentTerm = ((Manifest)tuple.v1()).getCurrentTerm();
                        }
                    }
                    Closeable closeable = null;
                    boolean success = false;
                    try {
                        ClusterState clusterState = this.prepareInitialClusterState(transportService, clusterService, ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).version(lastAcceptedVersion).metadata(this.upgradeMetadataForNode(metadata, indexMetadataVerifier, metadataUpgrader)).build());
                        if (DiscoveryNode.isMasterNode(settings)) {
                            LucenePersistedState lucenePersistedState = new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState);
                        } else {
                            AsyncPersistedState asyncPersistedState = new AsyncPersistedState(settings, transportService.getThreadPool(), new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState));
                        }
                        if (DiscoveryNode.canContainData(settings)) {
                            metaStateService.unreferenceAll();
                        } else {
                            metaStateService.deleteAll();
                        }
                        NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT, clusterState.metadata().oldestIndexVersion()), persistedClusterStateService.getDataPaths());
                        success = true;
                        if (success) break block30;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        IOUtils.closeWhileHandlingException(closeable);
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable)var14_25);
                }
                this.persistedState.set((Object)var14_25);
                return;
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
        }
        long currentTerm = 0L;
        ClusterState clusterState = this.prepareInitialClusterState(transportService, clusterService, ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).build());
        if (persistedClusterStateService.getDataPaths().length > 0) {
            try (PersistedClusterStateService.Writer persistenceWriter = persistedClusterStateService.createWriter();){
                persistenceWriter.writeFullStateAndCommit(0L, clusterState);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
            try {
                metaStateService.deleteAll();
                NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT, clusterState.metadata().oldestIndexVersion()), persistedClusterStateService.getDataPaths());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.persistedState.set((Object)new InMemoryPersistedState(0L, clusterState));
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        assert (clusterState.nodes().getLocalNode() == null) : "prepareInitialClusterState must only be called once";
        assert (transportService.getLocalNode() != null) : "transport service is not yet started";
        return Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(clusterState);
    }

    Metadata upgradeMetadataForNode(Metadata metadata, IndexMetadataVerifier indexMetadataVerifier, MetadataUpgrader metadataUpgrader) {
        return GatewayMetaState.upgradeMetadata(metadata, indexMetadataVerifier, metadataUpgrader);
    }

    static Metadata upgradeMetadata(Metadata metadata, IndexMetadataVerifier indexMetadataVerifier, MetadataUpgrader metadataUpgrader) {
        boolean changed = false;
        Metadata.Builder upgradedMetadata = Metadata.builder(metadata);
        for (IndexMetadata indexMetadata : metadata) {
            IndexMetadata newMetadata;
            changed |= indexMetadata != (newMetadata = indexMetadataVerifier.verifyIndexMetadata(indexMetadata, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetadata.put(newMetadata, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metadata.getTemplates(), metadataUpgrader.indexTemplateMetadataUpgraders, upgradedMetadata::removeTemplate, (s, indexTemplateMetadata) -> upgradedMetadata.put((IndexTemplateMetadata)indexTemplateMetadata))) {
            changed = true;
        }
        return changed ? upgradedMetadata.build() : metadata;
    }

    private static boolean applyPluginUpgraders(ImmutableOpenMap<String, IndexTemplateMetadata> existingData, UnaryOperator<Map<String, IndexTemplateMetadata>> upgrader, Consumer<String> removeData, BiConsumer<String, IndexTemplateMetadata> putData) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, (IndexTemplateMetadata)objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), (IndexTemplateMetadata)upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.persistedState.get()));
    }

    public boolean allPendingAsyncStatesWritten() {
        CoordinationState.PersistedState ps = (CoordinationState.PersistedState)this.persistedState.get();
        if (ps instanceof AsyncPersistedState) {
            return ((AsyncPersistedState)ps).allPendingAsyncStatesWritten();
        }
        return true;
    }

    private static class GatewayClusterApplier
    implements ClusterStateApplier {
        private static final Logger logger = LogManager.getLogger(GatewayClusterApplier.class);
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        private GatewayClusterApplier(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public void applyClusterState(ClusterChangedEvent event) {
            if (event.state().blocks().disableStatePersistence()) {
                this.incrementalClusterStateWriter.setIncrementalWrite(false);
                return;
            }
            try {
                if (event.state().term() > this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm()) {
                    this.incrementalClusterStateWriter.setCurrentTerm(event.state().term());
                }
                this.incrementalClusterStateWriter.updateClusterState(event.state());
                this.incrementalClusterStateWriter.setIncrementalWrite(true);
            }
            catch (WriteStateException e) {
                logger.warn("Exception occurred when storing new meta data", (Throwable)e);
            }
        }
    }

    static class LucenePersistedState
    implements CoordinationState.PersistedState {
        private long currentTerm;
        private ClusterState lastAcceptedState;
        private final PersistedClusterStateService persistedClusterStateService;
        private final AtomicReference<PersistedClusterStateService.Writer> persistenceWriter = new AtomicReference();
        private boolean writeNextStateFully;

        LucenePersistedState(PersistedClusterStateService persistedClusterStateService, long currentTerm, ClusterState lastAcceptedState) throws IOException {
            this.persistedClusterStateService = persistedClusterStateService;
            this.currentTerm = currentTerm;
            this.lastAcceptedState = lastAcceptedState;
            PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();
            try {
                writer.writeFullStateAndCommit(currentTerm, lastAcceptedState);
            }
            catch (Exception e) {
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            this.persistenceWriter.set(writer);
        }

        @Override
        public long getCurrentTerm() {
            return this.currentTerm;
        }

        @Override
        public ClusterState getLastAcceptedState() {
            return this.lastAcceptedState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(currentTerm, this.lastAcceptedState);
                } else {
                    this.writeNextStateFully = true;
                    this.getWriterSafe().writeIncrementalTermUpdateAndCommit(currentTerm, this.lastAcceptedState.version(), this.lastAcceptedState.metadata().oldestIndexVersion());
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException(e);
            }
            this.writeNextStateFully = false;
            this.currentTerm = currentTerm;
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                } else {
                    this.writeNextStateFully = true;
                    if (clusterState.term() != this.lastAcceptedState.term()) {
                        assert (clusterState.term() > this.lastAcceptedState.term()) : clusterState.term() + " vs " + this.lastAcceptedState.term();
                        this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                    } else {
                        this.getWriterSafe().writeIncrementalStateAndCommit(this.currentTerm, this.lastAcceptedState, clusterState);
                    }
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException(e);
            }
            this.writeNextStateFully = false;
            this.lastAcceptedState = clusterState;
        }

        private PersistedClusterStateService.Writer getWriterSafe() {
            PersistedClusterStateService.Writer writer = this.persistenceWriter.get();
            if (writer == null) {
                throw new AlreadyClosedException("persisted state has been closed");
            }
            if (writer.isOpen()) {
                return writer;
            }
            try {
                PersistedClusterStateService.Writer newWriter = this.persistedClusterStateService.createWriter();
                if (this.persistenceWriter.compareAndSet(writer, newWriter)) {
                    return newWriter;
                }
                assert (this.persistenceWriter.get() == null) : "expected no concurrent calls to getWriterSafe";
                newWriter.close();
                throw new AlreadyClosedException("persisted state has been closed");
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable)this.persistenceWriter.getAndSet(null));
        }
    }

    static class AsyncPersistedState
    extends InMemoryPersistedState {
        private static final Logger logger = LogManager.getLogger(AsyncPersistedState.class);
        static final String THREAD_NAME = "AsyncLucenePersistedState#updateTask";
        private final EsThreadPoolExecutor threadPoolExecutor;
        private final CoordinationState.PersistedState persistedState;
        boolean newCurrentTermQueued = false;
        boolean newStateQueued = false;
        private final Object mutex = new Object();
        static final CoordinationMetadata.VotingConfiguration staleStateConfiguration = new CoordinationMetadata.VotingConfiguration(Collections.singleton("STALE_STATE_CONFIG"));

        AsyncPersistedState(Settings settings, ThreadPool threadPool, CoordinationState.PersistedState persistedState) {
            super(persistedState.getCurrentTerm(), persistedState.getLastAcceptedState());
            String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
            this.threadPoolExecutor = EsExecutors.newFixed(nodeName + "/" + THREAD_NAME, 1, 1, EsExecutors.daemonThreadFactory(nodeName, THREAD_NAME), threadPool.getThreadContext());
            this.persistedState = persistedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentTerm(long currentTerm) {
            Object object = this.mutex;
            synchronized (object) {
                super.setCurrentTerm(currentTerm);
                if (this.newCurrentTermQueued) {
                    logger.trace("term update already queued (setting term to {})", (Object)currentTerm);
                } else {
                    logger.trace("queuing term update (setting term to {})", (Object)currentTerm);
                    this.newCurrentTermQueued = true;
                    if (!this.newStateQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            Object object = this.mutex;
            synchronized (object) {
                super.setLastAcceptedState(clusterState);
                if (this.newStateQueued) {
                    logger.trace("cluster state update already queued (setting cluster state to {})", (Object)clusterState.version());
                } else {
                    logger.trace("queuing cluster state update (setting cluster state to {})", (Object)clusterState.version());
                    this.newStateQueued = true;
                    if (!this.newCurrentTermQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        private void scheduleUpdate() {
            assert (Thread.holdsLock(this.mutex));
            assert (this.threadPoolExecutor.getQueue().isEmpty()) : "threadPoolExecutor queue not empty";
            this.threadPoolExecutor.execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.error("Exception occurred when storing new meta data", (Throwable)e);
                }

                @Override
                public void onRejection(Exception e) {
                    assert (threadPoolExecutor.isShutdown()) : "only expect rejections when shutting down";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doRun() {
                    ClusterState clusterState;
                    Long term;
                    Object object = mutex;
                    synchronized (object) {
                        if (newCurrentTermQueued) {
                            term = this.getCurrentTerm();
                            logger.trace("resetting newCurrentTermQueued");
                            newCurrentTermQueued = false;
                        } else {
                            term = null;
                        }
                        if (newStateQueued) {
                            clusterState = this.getLastAcceptedState();
                            logger.trace("resetting newStateQueued");
                            newStateQueued = false;
                        } else {
                            clusterState = null;
                        }
                    }
                    if (term != null) {
                        persistedState.setCurrentTerm(term);
                    }
                    if (clusterState != null) {
                        persistedState.setLastAcceptedState(AsyncPersistedState.resetVotingConfiguration(clusterState));
                    }
                }
            });
        }

        static ClusterState resetVotingConfiguration(ClusterState clusterState) {
            CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(clusterState.coordinationMetadata()).lastAcceptedConfiguration(staleStateConfiguration).lastCommittedConfiguration(staleStateConfiguration).build();
            return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).coordinationMetadata(newCoordinationMetadata).build()).build();
        }

        @Override
        public void close() throws IOException {
            try {
                ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
            }
            finally {
                this.persistedState.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean allPendingAsyncStatesWritten() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.newCurrentTermQueued || this.newStateQueued) {
                    return false;
                }
                return this.threadPoolExecutor.getActiveCount() == 0;
            }
        }
    }
}

