/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;

public abstract class AbstractShapeGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected Explicit<Boolean> coerce;
    protected Explicit<Orientation> orientation;

    public static FieldMapper.Parameter<Explicit<Boolean>> coerceParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean coerceByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("coerce", true, initializer, coerceByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Orientation>> orientationParam(Function<FieldMapper, Explicit<Orientation>> initializer) {
        return new FieldMapper.Parameter<Explicit<Orientation>>("orientation", true, () -> new Explicit<Orientation>(Orientation.RIGHT, false), (n, c, o) -> new Explicit<Orientation>(Orientation.fromString(o.toString()), true), initializer).setSerializer((b, f, v) -> b.field(f, (Enum)v.value()), v -> ((Orientation)((Object)((Object)v.value()))).toString());
    }

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, indexAnalyzers, ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
        this.coerce = coerce;
        this.orientation = orientation;
    }

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo, parser);
    }

    public boolean coerce() {
        return this.coerce.value();
    }

    public Orientation orientation() {
        return this.orientation.value();
    }

    public static abstract class AbstractShapeGeometryFieldType<T>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<T> {
        private final Orientation orientation;

        protected AbstractShapeGeometryFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<T> parser, Orientation orientation, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, parser, meta);
            this.orientation = orientation;
        }

        public Orientation orientation() {
            return this.orientation;
        }
    }
}

