/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.stats.outlierDetection;

import org.apache.sedona.util.DfUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sedona_sql.expressions.st_functions$;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class LocalOutlierFactor$ {
    public static LocalOutlierFactor$ MODULE$;
    private final String ID_COLUMN_NAME;
    private final String CONTENTS_COLUMN_NAME;

    static {
        new LocalOutlierFactor$();
    }

    private String ID_COLUMN_NAME() {
        return this.ID_COLUMN_NAME;
    }

    private String CONTENTS_COLUMN_NAME() {
        return this.CONTENTS_COLUMN_NAME;
    }

    public Dataset<Row> localOutlierFactor(Dataset<Row> dataframe, int k, String geometry, boolean handleTies, boolean useSphere, String resultColumnName) {
        Dataset ret;
        block3: {
            String string;
            if (k < 1) {
                throw new IllegalArgumentException("k must be a positive integer");
            }
            if (handleTies) {
                String prior = ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get("spark.sedona.join.knn.includeTieBreakers", "false");
                ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().set("spark.sedona.join.knn.includeTieBreakers", true);
                string = prior;
            } else {
                string = "false";
            }
            String prior = string;
            Function2 & java.io.Serializable & Serializable distanceFunction = useSphere ? (Function2 & java.io.Serializable & Serializable)(a, b) -> st_functions$.MODULE$.ST_DistanceSphere((Column)a, (Column)b) : (Function2 & java.io.Serializable & Serializable)(a, b) -> st_functions$.MODULE$.ST_Distance((Column)a, (Column)b);
            String useSpheroidString = useSphere ? "True" : "False";
            String geometryColumn = geometry == null ? DfUtils$.MODULE$.getGeometryColumnName(dataframe.schema()) : geometry;
            String KNNFunction = "ST_KNN";
            Dataset formattedDataframe = dataframe.withColumn(this.CONTENTS_COLUMN_NAME(), functions$.MODULE$.struct("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).withColumn(this.ID_COLUMN_NAME(), functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME())), 256)).withColumnRenamed(geometryColumn, "geometry");
            String arg$macro$1 = KNNFunction;
            Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)k);
            String arg$macro$3 = useSpheroidString;
            String arg$macro$4 = this.ID_COLUMN_NAME();
            String arg$macro$5 = this.ID_COLUMN_NAME();
            String arg$macro$6 = this.ID_COLUMN_NAME();
            Column[] columnArray = new Column[3];
            String arg$macro$7 = this.CONTENTS_COLUMN_NAME();
            columnArray[0] = functions$.MODULE$.first(new StringOps("l.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$7}))).alias(this.CONTENTS_COLUMN_NAME());
            columnArray[1] = functions$.MODULE$.max((Column)distanceFunction.apply((Object)functions$.MODULE$.col("l.geometry"), (Object)functions$.MODULE$.col("r.geometry"))).alias("k_distance");
            String arg$macro$8 = this.ID_COLUMN_NAME();
            columnArray[2] = functions$.MODULE$.collect_list(new StringOps("r.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$8}))).alias("neighbors");
            Dataset kDistanceDf = formattedDataframe.alias("l").join(formattedDataframe.alias("r"), functions$.MODULE$.expr(new StringOps("%s(l.geometry, r.geometry, %s + 1, %s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}))).$amp$amp((Object)functions$.MODULE$.col(new StringOps("l.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4}))).$eq$bang$eq((Object)functions$.MODULE$.col(new StringOps("r.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$5})))))).groupBy(new StringOps("l.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$6})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.first("l.geometry").alias("geometry"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])columnArray)).checkpoint();
            Dataset lrdDf = kDistanceDf.alias("A").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.ID_COLUMN_NAME()).alias("a_id"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.col("geometry").alias("a_geometry"), functions$.MODULE$.explode(functions$.MODULE$.col("neighbors")).alias("n_id")})).join(kDistanceDf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.ID_COLUMN_NAME()).alias("b_id"), functions$.MODULE$.col("geometry").alias("b_geometry"), functions$.MODULE$.col("k_distance").alias("b_k_distance")})), functions$.MODULE$.expr("n_id = b_id")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id"), functions$.MODULE$.col("b_id"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.array_max(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b_k_distance"), (Column)distanceFunction.apply((Object)functions$.MODULE$.col("a_geometry"), (Object)functions$.MODULE$.col("b_geometry"))}))).alias("rd")})).groupBy("a_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)).$div((Object)functions$.MODULE$.mean("rd").$plus((Object)BoxesRunTime.boxToDouble((double)1.0E-10))).alias("lrd"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_list(functions$.MODULE$.col("b_id")).alias("neighbors"), functions$.MODULE$.first(this.CONTENTS_COLUMN_NAME()).alias(this.CONTENTS_COLUMN_NAME())}));
            Column[] columnArray2 = new Column[2];
            String arg$macro$9 = this.CONTENTS_COLUMN_NAME();
            columnArray2[0] = functions$.MODULE$.col(new StringOps("%s.*").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$9})));
            columnArray2[1] = functions$.MODULE$.col(resultColumnName);
            ret = lrdDf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id"), functions$.MODULE$.col("lrd").alias("a_lrd"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.explode(functions$.MODULE$.col("neighbors")).alias("n_id")})).join(lrdDf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id").alias("b_id"), functions$.MODULE$.col("lrd").alias("b_lrd")})), functions$.MODULE$.expr("n_id = b_id")).groupBy("a_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.first(this.CONTENTS_COLUMN_NAME()).alias(this.CONTENTS_COLUMN_NAME()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("b_lrd").$div((Object)functions$.MODULE$.count("b_lrd").$times((Object)functions$.MODULE$.first("a_lrd"))).alias(resultColumnName)})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columnArray2));
            if (!handleTies) break block3;
            ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().set("spark.sedona.join.knn.includeTieBreakers", prior);
        }
        return ret;
    }

    public int localOutlierFactor$default$2() {
        return 20;
    }

    public String localOutlierFactor$default$3() {
        return null;
    }

    public boolean localOutlierFactor$default$4() {
        return false;
    }

    public boolean localOutlierFactor$default$5() {
        return false;
    }

    public String localOutlierFactor$default$6() {
        return "lof";
    }

    private LocalOutlierFactor$() {
        MODULE$ = this;
        this.ID_COLUMN_NAME = "__id";
        this.CONTENTS_COLUMN_NAME = "__contents";
    }
}

