/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002\u001f>\u00012C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\ti\u0002\u0011\t\u0012)A\u0005Q\"AQ\u000f\u0001BK\u0002\u0013\u0005a\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005o\"I\u0011q\u0001\u0001\u0003\u0016\u0004%\tA\u001e\u0005\n\u0003\u0013\u0001!\u0011#Q\u0001\n]D!\"a\u0003\u0001\u0005+\u0007I\u0011AA\u0007\u0011)\tY\u0002\u0001B\tB\u0003%\u0011q\u0002\u0005\u000b\u0003;\u0001!Q3A\u0005\u0002\u0005}\u0001BCA\u0014\u0001\tE\t\u0015!\u0003\u0002\"!Q\u0011\u0011\u0006\u0001\u0003\u0016\u0004%\t!a\u000b\t\u0015\u0005\u001d\u0003A!E!\u0002\u0013\ti\u0003\u0003\u0006\u0002J\u0001\u0011)\u001a!C\u0001\u0003\u0017B!\"!\u0018\u0001\u0005#\u0005\u000b\u0011BA'\u0011)\ty\u0006\u0001BK\u0002\u0013\u0005\u0011\u0011\r\u0005\u000b\u0003W\u0002!\u0011#Q\u0001\n\u0005\r\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"!#\u0001A\u0003%\u0011Q\r\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"!$\u0001A\u0003%\u0011Q\r\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003\u000fC\u0011\"!%\u0001\u0001\u0004%I!a%\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003KB\u0011\"!)\u0001\u0001\u0004%I!a\"\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!!\u001a\t\u0013\u0005-\u0006A1A\u0005\u0002\u00055\u0006\u0002CAd\u0001\u0001\u0006I!a,\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqAa\t\u0001\t\u0003\u0012)\u0003C\u0005\u0003.\u0001\t\t\u0011\"\u0001\u00030!I!\u0011\t\u0001\u0012\u0002\u0013\u0005!1\t\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u00057B\u0011Ba\u0018\u0001#\u0003%\tAa\u0017\t\u0013\t\u0005\u0004!%A\u0005\u0002\t\r\u0004\"\u0003B4\u0001E\u0005I\u0011\u0001B5\u0011%\u0011i\u0007AI\u0001\n\u0003\u0011y\u0007C\u0005\u0003t\u0001\t\n\u0011\"\u0001\u0003v!I!\u0011\u0010\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u007f\u0002\u0011\u0011!C!\u0005\u0003C\u0011Ba\"\u0001\u0003\u0003%\t!a\"\t\u0013\t%\u0005!!A\u0005\u0002\t-\u0005\"\u0003BK\u0001\u0005\u0005I\u0011\tBL\u0011%\u0011\t\u000bAA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0003(\u0002\t\t\u0011\"\u0011\u0003*\"I!1\u0016\u0001\u0002\u0002\u0013\u0005#Q\u0016\u0005\n\u0005_\u0003\u0011\u0011!C!\u0005c;\u0011B!.>\u0003\u0003E\tAa.\u0007\u0011qj\u0014\u0011!E\u0001\u0005sCq!!\u001c7\t\u0003\u00119\rC\u0005\u0003,Z\n\t\u0011\"\u0012\u0003.\"I!\u0011\u001a\u001c\u0002\u0002\u0013\u0005%1\u001a\u0005\n\u0005;4\u0014\u0011!CA\u0005?D\u0011B!<7\u0003\u0003%IAa<\u0003\u0013M#\u0018m\u0019\"bi\u000eD'B\u0001 @\u0003\u0011\u0019H/Y2\u000b\u0005\u0001\u000b\u0015AA5p\u0015\t\u00115)\u0001\u0006tK\u0012|g.Y0tc2T!\u0001R#\u0002\u0007M\fHN\u0003\u0002G\u000f\u0006)1\u000f]1sW*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0007\u0001\u0019R\u0001A'V;\u000e\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0004PE*,7\r\u001e\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bAA]3bI*\u0011!lQ\u0001\nG>tg.Z2u_JL!\u0001X,\u0003\u000b\t\u000bGo\u00195\u0011\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0003\u000fA\u0013x\u000eZ;diB\u0011a\fZ\u0005\u0003K~\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQB\u0019:pC\u0012\u001c\u0017m\u001d;D_:4W#\u00015\u0011\u0007%dg.D\u0001k\u0015\tYW)A\u0005ce>\fGmY1ti&\u0011QN\u001b\u0002\n\u0005J|\u0017\rZ2bgR\u0004\"a\u001c:\u000e\u0003AT!!]#\u0002\tU$\u0018\u000e\\\u0005\u0003gB\u0014\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006q!M]8bI\u000e\f7\u000f^\"p]\u001a\u0004\u0013!E:uC\u000e\u001cu\u000e\u001c7fGRLwN\\+sYV\tq\u000f\u0005\u0002y\u007f:\u0011\u00110 \t\u0003u~k\u0011a\u001f\u0006\u0003y.\u000ba\u0001\u0010:p_Rt\u0014B\u0001@`\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011apX\u0001\u0013gR\f7mQ8mY\u0016\u001cG/[8o+Jd\u0007%\u0001\nti\u0006\u001c7i\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0017aE:uC\u000e\u001cu\u000e\u001c7fGRLwN\u001c&t_:\u0004\u0013AB:dQ\u0016l\u0017-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\r\u000bQ\u0001^=qKNLA!!\u0007\u0002\u0014\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005!q\u000e\u001d;t+\t\t\t\u0003E\u0003y\u0003G9x/\u0003\u0003\u0002&\u0005\r!aA'ba\u0006)q\u000e\u001d;tA\u0005i1\u000f]1uS\u0006dg)\u001b7uKJ,\"!!\f\u0011\u000by\u000by#a\r\n\u0007\u0005ErL\u0001\u0004PaRLwN\u001c\t\u0005\u0003k\t\u0019%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u001d\u0001\u0018M]9vKRTA!!\u0010\u0002@\u0005YA-\u0019;bg>,(oY3t\u0015\r\t\teQ\u0001\nKb,7-\u001e;j_:LA!!\u0012\u00028\t9r)Z8QCJ\fX/\u001a;Ta\u0006$\u0018.\u00197GS2$XM]\u0001\u000fgB\fG/[1m\r&dG/\u001a:!\u00039!X-\u001c9pe\u0006dg)\u001b7uKJ,\"!!\u0014\u0011\u000by\u000by#a\u0014\u0011\t\u0005E\u0013\u0011L\u0007\u0003\u0003'R1APA+\u0015\u0011\t9&a\u0010\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0003\u0002\\\u0005M#A\u0004+f[B|'/\u00197GS2$XM]\u0001\u0010i\u0016l\u0007o\u001c:bY\u001aKG\u000e^3sA\u0005YA.[7ji\u001aKG\u000e^3s+\t\t\u0019\u0007E\u0003_\u0003_\t)\u0007E\u0002_\u0003OJ1!!\u001b`\u0005\rIe\u000e^\u0001\rY&l\u0017\u000e\u001e$jYR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005E\u0014QOA<\u0003s\nY(! \u0002\u0000\u0005\u0005\u00151\u0011\t\u0004\u0003g\u0002Q\"A\u001f\t\u000b\u0019\f\u0002\u0019\u00015\t\u000bU\f\u0002\u0019A<\t\r\u0005\u001d\u0011\u00031\u0001x\u0011\u001d\tY!\u0005a\u0001\u0003\u001fAq!!\b\u0012\u0001\u0004\t\t\u0003C\u0004\u0002*E\u0001\r!!\f\t\u000f\u0005%\u0013\u00031\u0001\u0002N!9\u0011qL\tA\u0002\u0005\r\u0014a\u00073fM\u0006,H\u000e^%uK6\u001cH*[7jiB+'OU3rk\u0016\u001cH/\u0006\u0002\u0002f\u0005aB-\u001a4bk2$\u0018\n^3ng2KW.\u001b;QKJ\u0014V-];fgR\u0004\u0013aH5uK6\u001cHj\\1e!J|7-Z:t%\u0016\u0004xN\u001d;UQJ,7\u000f[8mI\u0006\u0001\u0013\u000e^3ng2{\u0017\r\u001a)s_\u000e,7o\u001d*fa>\u0014H\u000f\u00165sKNDw\u000e\u001c3!\u0003-IG/Z7NCbdUM\u001a;\u0002\u001f%$X-\\'bq2+g\r^0%KF$B!!&\u0002\u001cB\u0019a,a&\n\u0007\u0005euL\u0001\u0003V]&$\b\"CAO/\u0005\u0005\t\u0019AA3\u0003\rAH%M\u0001\rSR,W.T1y\u0019\u00164G\u000fI\u0001\u0010Y\u0006\u001cHOU3q_J$8i\\;oi\u0006\u0019B.Y:u%\u0016\u0004xN\u001d;D_VtGo\u0018\u0013fcR!\u0011QSAT\u0011%\tiJGA\u0001\u0002\u0004\t)'\u0001\tmCN$(+\u001a9peR\u001cu.\u001e8uA\u00051Q.\u00199qKJ,\"!a,\u0011\t\u0005E\u00161Y\u0007\u0003\u0003gSA!!.\u00028\u0006AA-\u0019;bE&tGM\u0003\u0003\u0002:\u0006m\u0016a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003{\u000by,A\u0005gCN$XM\u001d=nY*\u0011\u0011\u0011Y\u0001\u0004G>l\u0017\u0002BAc\u0003g\u0013Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\btKRLE/Z7NCbdUM\u001a;\u0015\t\u0005U\u0015Q\u001a\u0005\b\u0003\u001ft\u0002\u0019AA3\u0003\u00151\u0018\r\\;f\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\t\t)\u000eE\u0003_\u0003/\fY.C\u0002\u0002Z~\u0013Q!\u0011:sCf\u00042AVAo\u0013\r\tyn\u0016\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0003A\u0019w\u000e\u001c7fGRLE/Z7MS:\\7\u000f\u0006\u0006\u0002\u0016\u0006\u0015\u0018\u0011^Aw\u0005\u0003Aa!a:!\u0001\u00049\u0018AE2pY2,7\r^5p]\n\u000b7/\u001a)bi\"Da!a;!\u0001\u00049\u0018AD2pY2,7\r^5p]*\u001bxN\u001c\u0005\b\u0003_\u0004\u0003\u0019AAy\u0003%IG/Z7MS:\\7\u000fE\u0003\u0002t\u0006ux/\u0004\u0002\u0002v*!\u0011q_A}\u0003\u001diW\u000f^1cY\u0016T1!a?`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\f)PA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bb\u0002B\u0002A\u0001\u0007!QA\u0001\u0013]\u0016,GmQ8v]RtU\r\u001f;Ji\u0016l7\u000fE\u0002_\u0005\u000fI1A!\u0003`\u0005\u001d\u0011un\u001c7fC:\f1bZ3u\u0013R,W\u000eT5oWRIqOa\u0004\u0003\u0014\tU!q\u0003\u0005\u0007\u0005#\t\u0003\u0019A<\u0002\u000f%$X-\\+sY\"9\u0011QQ\u0011A\u0002\u0005\u0015\u0004bBA\u0015C\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u0013\n\u0003\u0019AA'\u0003A1\u0017\u000e\u001c;fe\u000e{G\u000e\\3di&|g\u000e\u0006\u0005\u0003\u0006\tu!q\u0004B\u0011\u0011\u0019\tYO\ta\u0001o\"9\u0011\u0011\u0006\u0012A\u0002\u00055\u0002bBA%E\u0001\u0007\u0011QJ\u0001\u0014GJ,\u0017\r^3SK\u0006$WM\u001d$bGR|'/\u001f\u000b\u0003\u0005O\u00012A\u0016B\u0015\u0013\r\u0011Yc\u0016\u0002\u0017!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ss\u0006!1m\u001c9z)I\t\tH!\r\u00034\tU\"q\u0007B\u001d\u0005w\u0011iDa\u0010\t\u000f\u0019$\u0003\u0013!a\u0001Q\"9Q\u000f\nI\u0001\u0002\u00049\b\u0002CA\u0004IA\u0005\t\u0019A<\t\u0013\u0005-A\u0005%AA\u0002\u0005=\u0001\"CA\u000fIA\u0005\t\u0019AA\u0011\u0011%\tI\u0003\nI\u0001\u0002\u0004\ti\u0003C\u0005\u0002J\u0011\u0002\n\u00111\u0001\u0002N!I\u0011q\f\u0013\u0011\u0002\u0003\u0007\u00111M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)EK\u0002i\u0005\u000fZ#A!\u0013\u0011\t\t-#QK\u0007\u0003\u0005\u001bRAAa\u0014\u0003R\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'z\u0016AC1o]>$\u0018\r^5p]&!!q\u000bB'\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iFK\u0002x\u0005\u000f\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015$\u0006BA\b\u0005\u000f\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003l)\"\u0011\u0011\u0005B$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"A!\u001d+\t\u00055\"qI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u00119H\u000b\u0003\u0002N\t\u001d\u0013AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005{RC!a\u0019\u0003H\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa!\u0011\u00079\u0013))C\u0002\u0002\u0002=\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u000e\nM\u0005c\u00010\u0003\u0010&\u0019!\u0011S0\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001e>\n\t\u00111\u0001\u0002f\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001aB1!1\u0014BO\u0005\u001bk!!!?\n\t\t}\u0015\u0011 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0006\t\u0015\u0006\"CAOc\u0005\u0005\t\u0019\u0001BG\u0003!A\u0017m\u001d5D_\u0012,GCAA3\u0003!!xn\u0015;sS:<GC\u0001BB\u0003\u0019)\u0017/^1mgR!!Q\u0001BZ\u0011%\ti\nNA\u0001\u0002\u0004\u0011i)A\u0005Ti\u0006\u001c')\u0019;dQB\u0019\u00111\u000f\u001c\u0014\tY\u0012Yl\u0019\t\u0014\u0005{\u0013\u0019\r[<x\u0003\u001f\t\t#!\f\u0002N\u0005\r\u0014\u0011O\u0007\u0003\u0005\u007fS1A!1`\u0003\u001d\u0011XO\u001c;j[\u0016LAA!2\u0003@\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001d\u0015\u0005\t]\u0016!B1qa2LHCEA9\u0005\u001b\u0014yM!5\u0003T\nU'q\u001bBm\u00057DQAZ\u001dA\u0002!DQ!^\u001dA\u0002]Da!a\u0002:\u0001\u00049\bbBA\u0006s\u0001\u0007\u0011q\u0002\u0005\b\u0003;I\u0004\u0019AA\u0011\u0011\u001d\tI#\u000fa\u0001\u0003[Aq!!\u0013:\u0001\u0004\ti\u0005C\u0004\u0002`e\u0002\r!a\u0019\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u001dBu!\u0015q\u0016q\u0006Br!Aq&Q\u001d5xo\u0006=\u0011\u0011EA\u0017\u0003\u001b\n\u0019'C\u0002\u0003h~\u0013a\u0001V;qY\u0016D\u0004\"\u0003Bvu\u0005\u0005\t\u0019AA9\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\rF\u0001N\u0001")
public class StacBatch
implements Batch,
Product,
scala.Serializable {
    private final Broadcast<SerializableConfiguration> broadcastConf;
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final Option<Object> limitFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>> unapply(StacBatch stacBatch) {
        return StacBatch$.MODULE$.unapply(stacBatch);
    }

    public static StacBatch apply(Broadcast<SerializableConfiguration> broadcast, String string, String string2, StructType structType, Map<String, String> map, Option<GeoParquetSpatialFilter> option, Option<TemporalFilter> option2, Option<Object> option3) {
        return StacBatch$.MODULE$.apply(broadcast, string, string2, structType, map, option, option2, option3);
    }

    public static Function1<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<Broadcast<SerializableConfiguration>, Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, Function1<Option<Object>, StacBatch>>>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Broadcast<SerializableConfiguration> broadcastConf() {
        return this.broadcastConf;
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    public Option<Object> limitFilter() {
        return this.limitFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        Some some;
        int limit;
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option<Object> option = this.limitFilter();
        int n = option instanceof Some && (limit = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 0 ? limit : new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        int itemsLimitMax = n;
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable & scala.Serializable)() -> "1"))).toInt());
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((TraversableOnce)((TraversableLike)itemLinks.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String item = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                StacPartition stacPartition = new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                return stacPartition;
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)itemLinks, ArrayBuffer$.MODULE$.canBuildFrom())).grouped(partitionSize).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer items = (ArrayBuffer)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StacPartition stacPartition = new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            return stacPartition;
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                ArrayBuffer arrayBuffer = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(this.getItemLink(itemUrl, this.defaultItemsLimitPerRequest(), this.spatialFilter(), this.temporalFilter()), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public String getItemLink(String itemUrl, int defaultItemsLimitPerRequest, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String baseUrl = new StringBuilder(7).append(itemUrl).append("?limit=").append(defaultItemsLimitPerRequest).toString();
        String urlWithFilters = StacUtils$.MODULE$.addFiltersToUrl(baseUrl, spatialFilter, temporalFilter);
        return urlWithFilters;
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            boolean bl3;
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl3 = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl3 = !intervals.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
            bl = bl3;
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader(this.broadcastConf(), (StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return new StacBatch(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public Broadcast<SerializableConfiguration> copy$default$1() {
        return this.broadcastConf();
    }

    public String copy$default$2() {
        return this.stacCollectionUrl();
    }

    public String copy$default$3() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$4() {
        return this.schema();
    }

    public Map<String, String> copy$default$5() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$6() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$7() {
        return this.temporalFilter();
    }

    public Option<Object> copy$default$8() {
        return this.limitFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.broadcastConf();
                break;
            }
            case 1: {
                object = this.stacCollectionUrl();
                break;
            }
            case 2: {
                object = this.stacCollectionJson();
                break;
            }
            case 3: {
                object = this.schema();
                break;
            }
            case 4: {
                object = this.opts();
                break;
            }
            case 5: {
                object = this.spatialFilter();
                break;
            }
            case 6: {
                object = this.temporalFilter();
                break;
            }
            case 7: {
                object = this.limitFilter();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastConf();
        Broadcast<SerializableConfiguration> broadcast2 = stacBatch.broadcastConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.limitFilter();
        Option<Object> option6 = stacBatch.limitFilter();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Seq geometryTypes = (Seq)new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
        Seq bbox = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
        GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
        boolean bl = filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDateTime start = (LocalDateTime)tuple2._1();
        LocalDateTime end = (LocalDateTime)tuple2._2();
        boolean bl = filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        return bl;
    }

    public StacBatch(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        this.broadcastConf = broadcastConf;
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        this.limitFilter = limitFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        int limitPerRequest = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable & scala.Serializable)() -> "10"))).toInt();
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable & scala.Serializable)() -> "1000000"))).toInt();
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

