/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class PolyLineParser
extends ShapeParser {
    private final ShapeType shapeType;

    public PolyLineParser(GeometryFactory geometryFactory, ShapeType shapeType) {
        super(geometryFactory);
        this.shapeType = shapeType;
    }

    @Override
    public Geometry parseShape(ShapeReader reader) {
        reader.skip(32);
        int numParts = reader.readInt();
        int numPoints = reader.readInt();
        int[] offsets = this.readOffsets(reader, numParts, numPoints);
        Coordinate[] allCoordinates = this.shapeType == ShapeType.POLYLINEZ ? this.readCoordinatesWithZM(reader, numPoints) : (this.shapeType == ShapeType.POLYLINEM ? this.readCoordinatesWithM(reader, numPoints) : this.readCoordinates(reader, numPoints));
        LineString[] lines = new LineString[numParts];
        for (int i = 0; i < numParts; ++i) {
            int startIndex = offsets[i];
            int endIndex = offsets[i + 1];
            int pointCount = endIndex - startIndex;
            Coordinate[] partCoordinates = new Coordinate[pointCount];
            System.arraycopy(allCoordinates, startIndex, partCoordinates, 0, pointCount);
            lines[i] = this.geometryFactory.createLineString(partCoordinates);
        }
        if (numParts == 1) {
            return lines[0];
        }
        return this.geometryFactory.createMultiLineString(lines);
    }
}

