/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class EnumMeta {
    private final Map<String, Integer> enumNameToValueMap = new HashMap<String, Integer>();
    private final Map<Integer, Enum<?>> enumValues = new HashMap();

    public EnumMeta(Field protoField, JavaType javaType) {
        io.protostuff.compiler.model.Enum enumType = (io.protostuff.compiler.model.Enum)protoField.getType();
        for (EnumConstant enumConstant : enumType.getConstants()) {
            this.enumNameToValueMap.put(enumConstant.getName(), enumConstant.getValue());
            this.enumValues.put(enumConstant.getValue(), null);
        }
        if (!javaType.isEnumType()) {
            return;
        }
        try {
            Object[] values;
            Method method = javaType.getRawClass().getMethod("values", new Class[0]);
            method.setAccessible(true);
            for (Object value : values = (Object[])method.invoke(null, new Object[0])) {
                Enum enumValue = (Enum)value;
                this.enumValues.put(this.enumNameToValueMap.get(enumValue.name()), enumValue);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to collect enum values, class=" + javaType.getRawClass().getName(), e);
        }
    }

    public boolean containsValue(Integer value) {
        return this.enumValues.containsKey(value);
    }

    public Enum<?> getEnumByValue(int enumValue) {
        return this.enumValues.get(enumValue);
    }

    public Integer getValueByName(String name) {
        return this.enumNameToValueMap.get(name);
    }
}

