/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProducerFilter;
import org.apache.servicecomb.core.filter.impl.JacksonPropertyNodeNameProvider;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ParameterValidatorFilter
implements ProducerFilter,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidatorFilter.class);
    public static final String NAME = "validator";
    private static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    public static final String HIBERNATE_VALIDATE_PREFIX = "hibernate.validator";
    protected ExecutableValidator validator;
    private ApplicationContext applicationContext;

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    public void afterPropertiesSet() {
        this.validator = this.createValidatorFactory().getValidator().forExecutables();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private ValidatorFactory createValidatorFactory() {
        Configuration validatorConfiguration = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).propertyNodeNameProvider((PropertyNodeNameProvider)new JacksonPropertyNodeNameProvider())).messageInterpolator((MessageInterpolator)this.messageInterpolator());
        Set keys = ConfigUtil.propertiesWithPrefix((Environment)this.applicationContext.getEnvironment(), (String)HIBERNATE_VALIDATE_PREFIX);
        if (!keys.isEmpty()) {
            for (String key : keys) {
                validatorConfiguration.addProperty(key, this.applicationContext.getEnvironment().getProperty(key));
            }
        }
        return validatorConfiguration.buildValidatorFactory();
    }

    protected AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(ENABLE_EL, false).get();
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Set<ConstraintViolation<Object>> violations = this.doValidate(invocation);
        if (violations.size() > 0) {
            LOGGER.error("Parameter validation failed : " + violations);
            return AsyncUtils.completeExceptionally((Throwable)new ConstraintViolationException(violations));
        }
        return nextNode.onFilter(invocation);
    }

    protected Set<ConstraintViolation<Object>> doValidate(Invocation invocation) {
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        Object instance = producerOperation.getProducerInstance();
        Method method = producerOperation.getProducerMethod();
        Object[] args = invocation.toProducerArguments();
        return this.validator.validateParameters(instance, method, args, new Class[]{Default.class});
    }
}

