/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.common.utils.SPIOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SpringDataModule
extends SimpleModule
implements SPIOrder {
    private static final long serialVersionUID = 1L;

    public SpringDataModule() {
        super("springData");
        this.setMixInAnnotation(Page.class, PageMixin.class);
        this.setMixInAnnotation(Pageable.class, PageableMixin.class);
        this.setMixInAnnotation(Sort.class, SortMixin.class);
        this.setMixInAnnotation(PageImpl.class, PageMixin.class);
        this.setMixInAnnotation(PageRequest.class, PageableMixin.class);
    }

    public Object getTypeId() {
        return this.getModuleName();
    }

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    @JsonDeserialize(as=PageImpl.class)
    @JsonPropertyOrder(alphabetic=true)
    public static class PageMixin<T> {
        @JsonCreator
        public PageMixin(@JsonProperty(value="content") List<T> content, @JsonProperty(value="pageable") Pageable pageable, @JsonProperty(value="total") long total) {
        }
    }

    @JsonDeserialize(as=PageRequest.class)
    @JsonPropertyOrder(alphabetic=true)
    public static class PageableMixin {
        @JsonCreator
        public PageableMixin(@JsonProperty(value="pageNumber") int page, @JsonProperty(value="pageSize") int size, @JsonProperty(value="sort") Sort sort) {
        }
    }

    @JsonPropertyOrder(alphabetic=true)
    @JsonDeserialize(converter=SortConverter.class)
    @JsonSerialize(converter=SortMixinConverter.class)
    public static class SortMixin {
        private String[] properties;

        @JsonCreator
        public SortMixin() {
        }

        public void setProperties(String[] properties) {
            this.properties = properties;
        }

        public String[] getProperties() {
            return this.properties;
        }
    }

    public static class SortMixinConverter
    implements Converter<Sort, SortMixin> {
        public SortMixin convert(Sort value) {
            ArrayList<String> properties = new ArrayList<String>();
            for (Sort.Order order : value) {
                properties.add(order.getProperty());
            }
            SortMixin result = new SortMixin();
            result.setProperties(properties.toArray(new String[0]));
            return result;
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Sort.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(SortMixin.class);
        }
    }

    public static class SortConverter
    implements Converter<SortMixin, Sort> {
        public Sort convert(SortMixin value) {
            return Sort.by((String[])value.getProperties());
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(SortMixin.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Sort.class);
        }
    }
}

