/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FaultInjectionConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaultInjectionConfig.class);
    private static final Map<String, String> cfgCallback = new ConcurrentHashMapEx();

    public static int getConfigVal(String config, int defaultValue) {
        DynamicIntProperty dynamicIntProperty = DynamicPropertyFactory.getInstance().getIntProperty(config, defaultValue);
        cfgCallback.computeIfAbsent(config, key -> {
            dynamicIntProperty.addCallback(() -> {
                int newValue = dynamicIntProperty.get();
                String cfgName = dynamicIntProperty.getName();
                FaultInjectionUtil.setConfigCenterValue(cfgName, new AtomicInteger(newValue));
                LOGGER.info("{} changed to {}", (Object)cfgName, (Object)newValue);
            });
            return config;
        });
        return dynamicIntProperty.get();
    }

    @VisibleForTesting
    static Map<String, String> getCfgCallback() {
        return cfgCallback;
    }
}

