/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.servicecomb.foundation.ssl.CertificateUtil;
import org.apache.servicecomb.foundation.ssl.KeyStoreUtil;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerExt
extends X509ExtendedTrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(TrustManagerExt.class);
    private static final int WHITE_SIZE = 1024;
    private final X509ExtendedTrustManager trustManager;
    private final SSLOption option;
    private final SSLCustom custom;

    public TrustManagerExt(X509ExtendedTrustManager manager, SSLOption option, SSLCustom custom) {
        this.trustManager = manager;
        this.option = option;
        this.custom = custom;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this.option.isAuthPeer()) {
            return;
        }
        this.checkTrustedCustom(chain, null);
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this.option.isAuthPeer()) {
            return;
        }
        this.checkTrustedCustom(chain, null);
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        InetAddress inetAddress;
        if (!this.option.isAuthPeer()) {
            return;
        }
        String ip = null;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket && (inetAddress = socket.getInetAddress()) != null) {
            ip = inetAddress.getHostAddress();
        }
        this.checkTrustedCustom(chain, ip);
        this.trustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (!this.option.isAuthPeer()) {
            return;
        }
        String ip = null;
        if (engine != null) {
            SSLSession session = engine.getHandshakeSession();
            ip = session.getPeerHost();
        }
        this.checkTrustedCustom(chain, ip);
        this.trustManager.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        InetAddress inetAddress;
        if (!this.option.isAuthPeer()) {
            return;
        }
        String ip = null;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket && (inetAddress = socket.getInetAddress()) != null) {
            ip = inetAddress.getHostAddress();
        }
        this.checkTrustedCustom(chain, ip);
        this.trustManager.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (!this.option.isAuthPeer()) {
            return;
        }
        String ip = null;
        if (engine != null) {
            SSLSession session = engine.getHandshakeSession();
            ip = session.getPeerHost();
        }
        this.checkTrustedCustom(chain, ip);
        this.trustManager.checkServerTrusted(chain, authType, engine);
    }

    private void checkTrustedCustom(X509Certificate[] chain, String ip) throws CertificateException {
        this.checkCNHost(chain, ip);
        this.checkCNWhite(chain);
        this.checkCRL(chain);
    }

    /*
     * Unable to fully structure code
     */
    private void checkCNHost(X509Certificate[] chain, String ip) throws CertificateException {
        if (this.option.isCheckCNHost()) {
            owner = CertificateUtil.findOwner(chain);
            cns = CertificateUtil.getCN(owner);
            v0 = ipTmp = ip == null ? this.custom.getHost() : ip;
            if ("127.0.0.1".equals(ipTmp)) {
                try {
                    interfaces = NetworkInterface.getNetworkInterfaces();
                    if (interfaces == null) ** GOTO lbl23
                    while (interfaces.hasMoreElements()) {
                        nif = interfaces.nextElement();
                        ias = nif.getInetAddresses();
                        while (ias.hasMoreElements()) {
                            ia = ias.nextElement();
                            local = ia.getHostAddress();
                            if (!this.cnValid(cns, local)) continue;
                            return;
                        }
                    }
                }
                catch (SocketException e) {
                    throw new CertificateException("Get local adrress fail.");
                }
            } else if (this.cnValid(cns, ipTmp)) {
                return;
            }
lbl23:
            // 4 sources

            TrustManagerExt.LOG.error("CN does not match IP: e=" + cns + ",t=" + ip);
            throw new CertificateException("CN does not match IP: e=" + cns + ",t=" + ip);
        }
    }

    private boolean cnValid(Set<String> certsCN, String srcCN) {
        for (String cert : certsCN) {
            if (!cert.equals(srcCN)) continue;
            return true;
        }
        return false;
    }

    private void checkCNWhite(X509Certificate[] chain) throws CertificateException {
        if (this.option.isCheckCNWhite()) {
            FileInputStream fis = null;
            InputStreamReader reader = null;
            try {
                String white = this.option.getCheckCNWhiteFile();
                white = this.custom.getFullPath(white);
                fis = new FileInputStream(white);
                reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                char[] buffer = new char[1024];
                int len = reader.read(buffer);
                String[] cns = new String(buffer, 0, len).split("\\s+");
                X509Certificate owner = CertificateUtil.findOwner(chain);
                Set<String> certCN = CertificateUtil.getCN(owner);
                for (String c : cns) {
                    if (!this.cnValid(certCN, c)) continue;
                    return;
                }
            }
            catch (FileNotFoundException e) {
                throw new CertificateException("CN does not match white. no white file.");
            }
            catch (IOException e) {
                throw new CertificateException("CN does not match white. can not read file.");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    TrustManagerExt.ignore();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    TrustManagerExt.ignore();
                }
            }
            LOG.error("CN does not match white.");
            throw new CertificateException("CN does not match white.");
        }
    }

    private void checkCRL(X509Certificate[] chain) throws CertificateException {
        String crl = this.option.getCrl();
        File file = new File(crl = this.custom.getFullPath(crl));
        if (!file.exists()) {
            return;
        }
        CRL[] crls = KeyStoreUtil.createCRL(crl);
        X509Certificate owner = CertificateUtil.findOwner(chain);
        for (CRL c : crls) {
            if (!c.isRevoked(owner)) continue;
            LOG.error("certificate revoked");
            throw new CertificateException("certificate revoked");
        }
    }

    private static void ignore() {
    }
}

