/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.impl.enums;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Type;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.EnumMeta;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.AbstractReaders;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.RepeatedReadSchemas;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.impl.enums.EnumSchemaUtils;

public class EnumNotPackedReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (javaType.isJavaLangObject()) {
            return new EnumIntNotPackedSchema(protoField, propertyDescriptor);
        }
        return RepeatedReadSchemas.create(protoField, propertyDescriptor, new EnumNotPackedReaders(protoField, propertyDescriptor.getJavaType()));
    }

    private static class EnumIntNotPackedSchema<T>
    extends FieldSchema<T> {
        private final Getter<T, Collection<Integer>> getter;
        private final Setter<T, Collection<Integer>> setter;

        public EnumIntNotPackedSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int fieldNumber;
            ArrayList<Integer> collection = (ArrayList<Integer>)this.getter.get(message);
            if (collection == null) {
                collection = new ArrayList<Integer>();
                this.setter.set(message, collection);
            }
            do {
                int value = input.readEnum();
                collection.add(value);
            } while ((fieldNumber = input.readFieldNumber()) == this.fieldNumber);
            return fieldNumber;
        }
    }

    private static class EnumNotPackedReaders
    extends AbstractReaders<Enum<?>> {
        private final EnumMeta enumMeta;

        public EnumNotPackedReaders(Field protoField, JavaType javaType) {
            super(protoField, (Class)EnumSchemaUtils.constructEnumArrayClass(javaType));
            this.enumMeta = new EnumMeta(protoField, javaType.getContentType());
            this.collectionReader = (input, collection) -> {
                int fieldNumber;
                do {
                    int value;
                    Enum<?> enumValue;
                    if ((enumValue = this.enumMeta.getEnumByValue(value = input.readEnum())) == null) {
                        throw new IllegalStateException(String.format("invalid enum value %d for %s, proto field=%s:%s", value, javaType.getRawClass().getName(), ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
                    }
                    collection.add(enumValue);
                } while ((fieldNumber = input.readFieldNumber()) == this.fieldNumber);
                return fieldNumber;
            };
        }
    }
}

